package com.jz.common.utils.other;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @ClassName RegularTools
 * @author tangjunfeng
 * @date 2016年6月3日 下午5:54:18
 */
public class RegularTools {

	public static boolean isMobilePhone(String tel) {
		Pattern p = Pattern.compile("((1)\\d{10})|((09)\\d{8})$");// ((13[0-9])|(15[^4，\\D])|(18[0,5-9])|(14[0-9]))\\d{8}$");
		// Pattern p = Pattern.compile("(1)\\d{10}$");
		boolean isExist = false;
		if (p.matcher(tel).matches())
			isExist = true;
		return isExist;
	}

	public static boolean isGlobalMobilePhone(String tel) {
		Pattern p = Pattern.compile("^(\\d|\\+|-|\\s){10,}$");
		boolean isExist = false;
		if (p.matcher(tel).matches())
			isExist = true;
		return isExist;
	}

	public static boolean isEmail(String str) {
		Pattern p1 = Pattern.compile("\\w+@(\\w+.)+[a-z]{2,3}");
		Matcher m = p1.matcher(str);
		return m.matches();
	}

	public static boolean isNumber(String str) {
		Pattern p1 = Pattern.compile("^[0-9_]+$");
		Matcher m = p1.matcher(str);
		return m.matches();
	}

	public static boolean isNetAddress(String str) {
		String reg = "((25[0-5]|2[0-4]\\d|((1\\d{2})|([1-9]?\\d)))\\.){3}(25[0-5]|2[0-4]\\d|((1\\d{2})|([1-9]?\\d)))";
		Pattern p1 = Pattern.compile(reg);
		Matcher m = p1.matcher(str);
		return m.matches();
	}

	// public static void main(String[] args) {
	// System.out.println(isMobilePhone("15311719578"));
	// System.out.println(isMobilePhone("0912345678"));
	// System.out.println(isMobilePhone("153117195781"));
	// System.out.println(isMobilePhone("09123456781"));
	// System.out.println(isMobilePhone("20923892843"));
	// }

}
