package com.jz.common.utils.i18n.cn;

import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jz.common.utils.text.StringTools;

import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

public class PinyinTool {

	private static final Logger logger = LoggerFactory.getLogger(PinyinTool.class);

	public static String getPingYin(String arg0) {
		char[] t1 = null;
		t1 = arg0.toCharArray();
		String[] t2 = new String[t1.length];
		HanyuPinyinOutputFormat t3 = new HanyuPinyinOutputFormat();
		t3.setCaseType(HanyuPinyinCaseType.LOWERCASE);
		t3.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
		t3.setVCharType(HanyuPinyinVCharType.WITH_V);
		String t4 = "";
		int t0 = t1.length;
		try {
			for (int i = 0; i < t0; i++) {
				// 判断是否为汉字字符
				if (java.lang.Character.toString(t1[i]).matches("[\\u4E00-\\u9FA5]+")) {
					t2 = net.sourceforge.pinyin4j.PinyinHelper.toHanyuPinyinStringArray(t1[i], t3);
					if (t2 == null)
						t2 = new String[] { "?" };
					t4 += t2[0];
				} else
					t4 += java.lang.Character.toString(t1[i]);
			}
			return t4.trim();
		} catch (BadHanyuPinyinOutputFormatCombination e) {
			logger.error(e.getMessage(), e);
			return null;
		}
	}

	// 返回中文的首字母
	public static String getPinYinHeadChar(String arg0) {
		String convert = "";
		for (int j = 0; j < arg0.length(); j++) {
			char word = arg0.charAt(j);
			String[] pinyinArray = net.sourceforge.pinyin4j.PinyinHelper.toHanyuPinyinStringArray(word);
			if (pinyinArray != null) {
				convert += pinyinArray[0].charAt(0);
			} else {
				convert += word;
			}
		}
		return convert;
	}

	/** 获取拼音和首字符 */
	public static Pair<String, String> getPinyinAndHeadChar(String arg0) {
		if (StringTools.isEmptyAndBlank(arg0)) {
			return Pair.of("", "");
		}
		HanyuPinyinOutputFormat t3 = new HanyuPinyinOutputFormat();
		t3.setCaseType(HanyuPinyinCaseType.LOWERCASE);
		t3.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
		t3.setVCharType(HanyuPinyinVCharType.WITH_V);
		StringBuffer totalConvert = new StringBuffer();
		StringBuffer headConvert = new StringBuffer();
		try {
			for (int j = 0; j < arg0.length(); j++) {
				char word = arg0.charAt(j);
				if (java.lang.Character.toString(word).matches("[\\u4E00-\\u9FA5]+")) {
					String[] pinyinArray = net.sourceforge.pinyin4j.PinyinHelper.toHanyuPinyinStringArray(word, t3);
					if (pinyinArray != null) {
						headConvert.append(pinyinArray[0].charAt(0));
						totalConvert.append(pinyinArray[0]);
					} else {
						headConvert.append(word);
						totalConvert.append(word);
					}
				} else {
					headConvert.append(word);
					totalConvert.append(word);
				}
			}
		} catch (BadHanyuPinyinOutputFormatCombination e) {
			logger.error(e.getMessage(), e);
		}
		return Pair.of(totalConvert.toString(), headConvert.toString());
	}

}
