package com.jz.common.utils.http.v2;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Map.Entry;
import java.util.concurrent.TimeUnit;

import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.http.ConnectTools;
import com.jz.common.utils.text.StringTools;

/**
 * @Title HttpServletRequest
 * @Package com.jz.common.utils.http
 * @author tangjunfeng
 * @date 2019年11月15日 下午12:11:41
 * @version V1.0
 */
public class HttpServletRequest {

	private static final int DEFAULT_LIFE_TIME = 10000;
	private static final int DEFAULT_TIME_OUT = 5000;
	private static final String USER_AGENT = "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:20.0) Gecko/20191115 Gymchina/20.0";
	static final String UTF8 = "UTF-8";

	static String sendHttpRequest(HttpRequestBase request, String charsetName, Map<String, String> header,
			Logger logger) throws IOException {
		HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
		// 设置单个连接有效时长
		httpClientBuilder.setConnectionTimeToLive(DEFAULT_LIFE_TIME, TimeUnit.MILLISECONDS);
		CloseableHttpClient closeableHttpClient = httpClientBuilder.build();
		String result = null;
		try {
			RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(DEFAULT_TIME_OUT)
					.setConnectTimeout(DEFAULT_TIME_OUT).build();
			// 设置请求和传输超时时间
			request.setConfig(requestConfig);
			request.setHeader("accept", "*/*");
			request.setHeader("connection", "keep-alive");
			request.setHeader("user-agent", USER_AGENT);

			if (ArrayMapTools.isNotEmpty(header)) {
				for (Entry<String, String> entry : header.entrySet())
					request.setHeader(entry.getKey(), entry.getValue());
			}

			HttpResponse response = closeableHttpClient.execute(request);
			String charset = ConnectTools.getCharsetFromResponse(response);
			charsetName = StringTools.isNotEmpty(charset) ? charset : charsetName;
			String _temp = null != response.getEntity()
					? EntityUtils.toString(response.getEntity(), Charset.forName(charsetName))
					: null;
			if (null != logger)
				logger.info("CODE : {} || Result = {}", response.getStatusLine().getStatusCode(), _temp);
			if (HttpStatus.SC_OK == response.getStatusLine().getStatusCode() && StringTools.isNotEmpty(_temp))
				result = _temp;
		} finally {
			closeableHttpClient.close();
		}
		return result;
	}
}
