package com.jz.common.utils.http.v2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jz.common.utils.collection.ArrayMapTools;

public class HttpServletPost extends HttpServletRequest {

	private static final Logger logger = LoggerFactory.getLogger(HttpServletPost.class);

	public static String send(String url) {
		return send(url, null);
	}

	public static String send(String url, Map<String, String> params) {
		return send(url, params, UTF8, null, true);
	}

	public static String send(String url, Map<String, String> params, String charsetName) {
		return send(url, params, charsetName, null, true);
	}

	public static String send(String url, Map<String, String> params, boolean showLog) {
		return send(url, params, UTF8, null, showLog);
	}

	public static String send(String url, Map<String, String> params, Map<String, String> header) {
		return send(url, params, UTF8, header, true);
	}

	public static String send(String url, Map<String, String> params, String charsetName, Map<String, String> header) {
		return send(url, params, UTF8, header, true);
	}

	public static String send(String url, Map<String, String> params, Map<String, String> header, boolean showLog) {
		return send(url, params, UTF8, header, showLog);
	}

	public static String send(String url, Map<String, String> params, String charsetName, Map<String, String> header,
			boolean showLog) {
		if (showLog)
			logger.info("POST : {}{}{}", url, (url.indexOf("?") > 0 ? "&" : "?"), params);
		List<NameValuePair> parameters = new ArrayList<>();
		if (ArrayMapTools.isNotEmpty(params)) {
			for (Entry<String, String> entry : params.entrySet()) {
				parameters.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
			}
		}
		// 特殊字符转义
		try {
			return sendPost(new UrlEncodedFormEntity(parameters, charsetName), url, charsetName, header, showLog);
		} catch (IOException e) {
			logger.error(e.getMessage(), e);
			return null;
		}
	}

	public static String sendBody(String url, String body) {
		return sendBody(url, body, UTF8, null, true);
	}

	public static String sendBody(String url, String body, String charsetName) {
		return sendBody(url, body, charsetName, null, true);
	}

	public static String sendBody(String url, String body, boolean showLog) {
		return sendBody(url, body, UTF8, null, showLog);
	}

	public static String sendBody(String url, String body, Map<String, String> header) {
		return sendBody(url, body, UTF8, header, true);
	}

	public static String sendBody(String url, String body, Map<String, String> header, boolean showLog) {
		return sendBody(url, body, UTF8, header, showLog);
	}

	public static String sendBody(String url, String body, String charsetName, Map<String, String> header,
			boolean showLog) {
		if (showLog)
			logger.info("POST : {}, BODY : {}", url, body);
		try {
			return sendPost(new StringEntity(body, charsetName), url, charsetName, header, showLog);
		} catch (IOException e) {
			logger.error(e.getMessage(), e);
			return null;
		}
	}

	private static String sendPost(HttpEntity entity, String url, String charsetName, Map<String, String> header, boolean showLog) throws IOException {
		HttpPost post = new HttpPost(url);
		post.setEntity(entity);
		return sendHttpRequest(post, charsetName, header, showLog ? logger : null);
	}
}
