package com.jz.common.utils.http.v2;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Map.Entry;

import org.apache.http.client.methods.HttpGet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jz.common.utils.collection.ArrayMapTools;

public class HttpServletGet extends HttpServletRequest {

	private static Logger logger = LoggerFactory.getLogger(HttpServletGet.class);

	public static String send(String url) {
		return send(url, null);
	}

	public static String send(String url, Map<String, String> params) {
		return send(url, params, UTF8, null, true);
	}

	public static String send(String url, Map<String, String> params, String charsetName) {
		return send(url, params, charsetName, null, true);
	}

	public static String send(String url, Map<String, String> params, boolean showLog) {
		return send(url, params, UTF8, null, showLog);
	}

	public static String send(String url, Map<String, String> params, Map<String, String> header) {
		return send(url, params, UTF8, header, true);
	}

	public static String send(String url, Map<String, String> params, String charsetName, Map<String, String> header) {
		return send(url, params, UTF8, header, true);
	}

	public static String send(String url, Map<String, String> params, Map<String, String> header, boolean showLog) {
		return send(url, params, UTF8, header, showLog);
	}

	public static String send(String url, Map<String, String> params, String charsetName, Map<String, String> header,
			boolean showLog) {
		try {
			StringBuilder sb = new StringBuilder();
			if (ArrayMapTools.isNotEmpty(params)) {
				for (Entry<String, String> entry : params.entrySet()) {
					sb.append(entry.getKey()).append("=");
					sb.append(URLEncoder.encode(entry.getValue(), charsetName)).append("&");
				}
				sb.delete(sb.length() - 1, sb.length());
			}

			if (sb.length() > 0)
				url += (url.indexOf("?") > 0 ? "&" : "?") + sb.toString();
			if (showLog)
				logger.info("GET : {}", url);
			return sendHttpRequest(new HttpGet(url), charsetName, header, showLog ? logger : null);
		} catch (IOException e) {
			logger.error(e.getMessage(), e);
			return null;
		}
	}

}
