/*
 * Decompiled with CFR 0.152.
 */
package com.jz.common.utils.text;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;

abstract class AbstractStringTools
extends StringUtils {
    private static final String FOLDER_SEPARATOR = "/";
    private static final char EXTENSION_SEPARATOR = '.';

    AbstractStringTools() {
    }

    public static boolean isEmpty(Object str) {
        return str == null || "".equals(str);
    }

    public static boolean hasLength(CharSequence str) {
        return str != null && str.length() > 0;
    }

    public static boolean hasLength(String str) {
        return AbstractStringTools.hasLength((CharSequence)str);
    }

    public static boolean hasText(CharSequence str) {
        if (!AbstractStringTools.hasLength(str)) {
            return false;
        }
        int strLen = str.length();
        int i = 0;
        while (i < strLen) {
            if (!Character.isWhitespace(str.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean hasText(String str) {
        return AbstractStringTools.hasText((CharSequence)str);
    }

    public static boolean containsWhitespace(CharSequence str) {
        if (!AbstractStringTools.hasLength(str)) {
            return false;
        }
        int strLen = str.length();
        int i = 0;
        while (i < strLen) {
            if (Character.isWhitespace(str.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean containsWhitespace(String str) {
        return AbstractStringTools.containsWhitespace((CharSequence)str);
    }

    public static String trimWhitespace(String str) {
        if (!AbstractStringTools.hasLength(str)) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(0))) {
            sb.deleteCharAt(0);
        }
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(sb.length() - 1))) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String trimAllWhitespace(String str) {
        if (!AbstractStringTools.hasLength(str)) {
            return str;
        }
        int len = str.length();
        StringBuilder sb = new StringBuilder(str.length());
        int i = 0;
        while (i < len) {
            char c = str.charAt(i);
            if (!Character.isWhitespace(c)) {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String trimLeadingWhitespace(String str) {
        if (!AbstractStringTools.hasLength(str)) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(0))) {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }

    public static String trimTrailingWhitespace(String str) {
        if (!AbstractStringTools.hasLength(str)) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(sb.length() - 1))) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String trimLeadingCharacter(String str, char leadingCharacter) {
        if (!AbstractStringTools.hasLength(str)) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        while (sb.length() > 0 && sb.charAt(0) == leadingCharacter) {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }

    public static String trimTrailingCharacter(String str, char trailingCharacter) {
        if (!AbstractStringTools.hasLength(str)) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        while (sb.length() > 0 && sb.charAt(sb.length() - 1) == trailingCharacter) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static boolean startsWithIgnoreCase(String str, String prefix) {
        if (str == null || prefix == null) {
            return false;
        }
        if (str.startsWith(prefix)) {
            return true;
        }
        if (str.length() < prefix.length()) {
            return false;
        }
        String lcStr = str.substring(0, prefix.length()).toLowerCase();
        String lcPrefix = prefix.toLowerCase();
        return lcStr.equals(lcPrefix);
    }

    public static boolean endsWithIgnoreCase(String str, String suffix) {
        if (str == null || suffix == null) {
            return false;
        }
        if (str.endsWith(suffix)) {
            return true;
        }
        if (str.length() < suffix.length()) {
            return false;
        }
        String lcStr = str.substring(str.length() - suffix.length()).toLowerCase();
        String lcSuffix = suffix.toLowerCase();
        return lcStr.equals(lcSuffix);
    }

    public static boolean substringMatch(CharSequence str, int index, CharSequence substring) {
        int j = 0;
        while (j < substring.length()) {
            int i = index + j;
            if (i >= str.length() || str.charAt(i) != substring.charAt(j)) {
                return false;
            }
            ++j;
        }
        return true;
    }

    public static int countOccurrencesOf(String str, String sub) {
        int idx;
        if (str == null || sub == null || str.length() == 0 || sub.length() == 0) {
            return 0;
        }
        int count = 0;
        int pos = 0;
        while ((idx = str.indexOf(sub, pos)) != -1) {
            ++count;
            pos = idx + sub.length();
        }
        return count;
    }

    public static String replace(String inString, String oldPattern, String newPattern) {
        if (!AbstractStringTools.hasLength(inString) || !AbstractStringTools.hasLength(oldPattern) || newPattern == null) {
            return inString;
        }
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        int index = inString.indexOf(oldPattern);
        int patLen = oldPattern.length();
        while (index >= 0) {
            sb.append(inString.substring(pos, index));
            sb.append(newPattern);
            pos = index + patLen;
            index = inString.indexOf(oldPattern, pos);
        }
        sb.append(inString.substring(pos));
        return sb.toString();
    }

    public static String delete(String inString, String pattern) {
        return AbstractStringTools.replace(inString, pattern, "");
    }

    public static String deleteAny(String inString, String charsToDelete) {
        if (!AbstractStringTools.hasLength(inString) || !AbstractStringTools.hasLength(charsToDelete)) {
            return inString;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < inString.length()) {
            char c = inString.charAt(i);
            if (charsToDelete.indexOf(c) == -1) {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String quote(String str) {
        return str != null ? "'" + str + "'" : null;
    }

    public static Object quoteIfString(Object obj) {
        return obj instanceof String ? AbstractStringTools.quote((String)obj) : obj;
    }

    public static String unqualify(String qualifiedName) {
        return AbstractStringTools.unqualify(qualifiedName, '.');
    }

    public static String unqualify(String qualifiedName, char separator) {
        return qualifiedName.substring(qualifiedName.lastIndexOf(separator) + 1);
    }

    public static String capitalize(String str) {
        return AbstractStringTools.changeFirstCharacterCase(str, true);
    }

    public static String uncapitalize(String str) {
        return AbstractStringTools.changeFirstCharacterCase(str, false);
    }

    private static String changeFirstCharacterCase(String str, boolean capitalize) {
        if (str == null || str.length() == 0) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str.length());
        if (capitalize) {
            sb.append(Character.toUpperCase(str.charAt(0)));
        } else {
            sb.append(Character.toLowerCase(str.charAt(0)));
        }
        sb.append(str.substring(1));
        return sb.toString();
    }

    public static String getFilename(String path) {
        if (path == null) {
            return null;
        }
        int separatorIndex = path.lastIndexOf(FOLDER_SEPARATOR);
        return separatorIndex != -1 ? path.substring(separatorIndex + 1) : path;
    }

    public static String getFilenameExtension(String path) {
        if (path == null) {
            return null;
        }
        int extIndex = path.lastIndexOf(46);
        if (extIndex == -1) {
            return null;
        }
        int folderIndex = path.lastIndexOf(FOLDER_SEPARATOR);
        if (folderIndex > extIndex) {
            return null;
        }
        return path.substring(extIndex + 1);
    }

    public static String stripFilenameExtension(String path) {
        if (path == null) {
            return null;
        }
        int extIndex = path.lastIndexOf(46);
        if (extIndex == -1) {
            return path;
        }
        int folderIndex = path.lastIndexOf(FOLDER_SEPARATOR);
        if (folderIndex > extIndex) {
            return path;
        }
        return path.substring(0, extIndex);
    }

    public static String applyRelativePath(String path, String relativePath) {
        int separatorIndex = path.lastIndexOf(FOLDER_SEPARATOR);
        if (separatorIndex != -1) {
            String newPath = path.substring(0, separatorIndex);
            if (!relativePath.startsWith(FOLDER_SEPARATOR)) {
                newPath = String.valueOf(newPath) + FOLDER_SEPARATOR;
            }
            return String.valueOf(newPath) + relativePath;
        }
        return relativePath;
    }

    public static Locale parseLocaleString(String localeString) {
        int endIndexOfCountryCode;
        String[] parts = AbstractStringTools.tokenizeToStringArray(localeString, "_ ", false, false);
        String language = parts.length > 0 ? parts[0] : "";
        String country = parts.length > 1 ? parts[1] : "";
        AbstractStringTools.validateLocalePart(language);
        AbstractStringTools.validateLocalePart(country);
        String variant = "";
        if (parts.length > 2 && (variant = AbstractStringTools.trimLeadingWhitespace(localeString.substring(endIndexOfCountryCode = localeString.indexOf(country, language.length()) + country.length()))).startsWith("_")) {
            variant = AbstractStringTools.trimLeadingCharacter(variant, '_');
        }
        return language.length() > 0 ? new Locale(language, country, variant) : null;
    }

    private static void validateLocalePart(String localePart) {
        int i = 0;
        while (i < localePart.length()) {
            char ch = localePart.charAt(i);
            if (ch != '_' && ch != ' ' && !Character.isLetterOrDigit(ch)) {
                throw new IllegalArgumentException("Locale part \"" + localePart + "\" contains invalid characters");
            }
            ++i;
        }
    }

    public static String toLanguageTag(Locale locale) {
        return String.valueOf(locale.getLanguage()) + (AbstractStringTools.hasText(locale.getCountry()) ? "-" + locale.getCountry() : "");
    }

    public static TimeZone parseTimeZoneString(String timeZoneString) {
        TimeZone timeZone = TimeZone.getTimeZone(timeZoneString);
        if ("GMT".equals(timeZone.getID()) && !timeZoneString.startsWith("GMT")) {
            throw new IllegalArgumentException("Invalid time zone specification '" + timeZoneString + "'");
        }
        return timeZone;
    }

    public static String[] toStringArray(Collection<String> collection) {
        if (collection == null) {
            return null;
        }
        return collection.toArray(new String[collection.size()]);
    }

    public static String[] toStringArray(Enumeration<String> enumeration) {
        if (enumeration == null) {
            return null;
        }
        ArrayList<String> list = Collections.list(enumeration);
        return list.toArray(new String[list.size()]);
    }

    public static String[] split(String toSplit, String delimiter) {
        if (!AbstractStringTools.hasLength(toSplit) || !AbstractStringTools.hasLength(delimiter)) {
            return null;
        }
        int offset = toSplit.indexOf(delimiter);
        if (offset < 0) {
            return null;
        }
        String beforeDelimiter = toSplit.substring(0, offset);
        String afterDelimiter = toSplit.substring(offset + delimiter.length());
        return new String[]{beforeDelimiter, afterDelimiter};
    }

    public static String[] tokenizeToStringArray(String str, String delimiters) {
        return AbstractStringTools.tokenizeToStringArray(str, delimiters, true, true);
    }

    public static String[] tokenizeToStringArray(String str, String delimiters, boolean trimTokens, boolean ignoreEmptyTokens) {
        if (str == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(str, delimiters);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (trimTokens) {
                token = token.trim();
            }
            if (ignoreEmptyTokens && token.length() <= 0) continue;
            tokens.add(token);
        }
        return AbstractStringTools.toStringArray(tokens);
    }

    public static String[] delimitedListToStringArray(String str, String delimiter) {
        return AbstractStringTools.delimitedListToStringArray(str, delimiter, null);
    }

    public static String[] delimitedListToStringArray(String str, String delimiter, String charsToDelete) {
        if (str == null) {
            return new String[0];
        }
        if (delimiter == null) {
            return new String[]{str};
        }
        ArrayList<String> result = new ArrayList<String>();
        if ("".equals(delimiter)) {
            int i = 0;
            while (i < str.length()) {
                result.add(AbstractStringTools.deleteAny(str.substring(i, i + 1), charsToDelete));
                ++i;
            }
        } else {
            int delPos;
            int pos = 0;
            while ((delPos = str.indexOf(delimiter, pos)) != -1) {
                result.add(AbstractStringTools.deleteAny(str.substring(pos, delPos), charsToDelete));
                pos = delPos + delimiter.length();
            }
            if (str.length() > 0 && pos <= str.length()) {
                result.add(AbstractStringTools.deleteAny(str.substring(pos), charsToDelete));
            }
        }
        return AbstractStringTools.toStringArray(result);
    }

    public static String[] commaDelimitedListToStringArray(String str) {
        return AbstractStringTools.delimitedListToStringArray(str, ",");
    }

    public static Set<String> commaDelimitedListToSet(String str) {
        String[] tokens;
        TreeSet<String> set = new TreeSet<String>();
        String[] stringArray = tokens = AbstractStringTools.commaDelimitedListToStringArray(str);
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            set.add(token);
            ++n2;
        }
        return set;
    }
}

