/*
 * Decompiled with CFR 0.152.
 */
package com.jz.common.utils.mail;

import com.jz.common.utils.mail.MailSenderInfo;
import com.jz.common.utils.mail.MyAuthenticator;
import com.jz.common.utils.text.StringTools;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class SimpleMailSender {
    public static boolean sendTextMail(MailSenderInfo mailInfo) {
        MyAuthenticator authenticator = null;
        Properties pro = mailInfo.getProperties();
        if (mailInfo.isValidate()) {
            authenticator = new MyAuthenticator(mailInfo.getUserName(), mailInfo.getPassword());
        }
        Session sendMailSession = Session.getDefaultInstance((Properties)pro, authenticator);
        try {
            MimeMessage mailMessage = new MimeMessage(sendMailSession);
            InternetAddress from = new InternetAddress(mailInfo.getFromAddress());
            mailMessage.setFrom((Address)from);
            InternetAddress to = new InternetAddress(mailInfo.getToAddress());
            mailMessage.setRecipient(Message.RecipientType.TO, (Address)to);
            mailMessage.setSubject(mailInfo.getSubject());
            mailMessage.setSentDate(new Date());
            String mailContent = mailInfo.getContent();
            mailMessage.setText(mailContent);
            Transport.send((Message)mailMessage);
            return true;
        }
        catch (MessagingException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public boolean sendHtmlMail(MailSenderInfo mailInfo) {
        MyAuthenticator authenticator = null;
        Properties pro = mailInfo.getProperties();
        if (mailInfo.isValidate()) {
            authenticator = new MyAuthenticator(mailInfo.getUserName(), mailInfo.getPassword());
        }
        Session sendMailSession = Session.getDefaultInstance((Properties)pro, authenticator);
        try {
            MimeMessage mailMessage = new MimeMessage(sendMailSession);
            InternetAddress from = new InternetAddress(mailInfo.getFromAddress());
            mailMessage.setFrom((Address)from);
            if (mailInfo.getToAddress().indexOf(";") > 0) {
                String[] address = mailInfo.getToAddress().split(";");
                Address[] adds = new Address[address.length];
                int i = 0;
                while (i < address.length) {
                    if (StringTools.isNotEmpty((CharSequence)address[i])) {
                        adds[i] = new InternetAddress(address[i]);
                    }
                    ++i;
                }
                mailMessage.setRecipients(Message.RecipientType.TO, adds);
            } else {
                InternetAddress to = new InternetAddress(mailInfo.getToAddress());
                mailMessage.setRecipient(Message.RecipientType.TO, (Address)to);
            }
            mailMessage.setSubject(mailInfo.getSubject());
            mailMessage.setSentDate(new Date());
            MimeMultipart mainPart = new MimeMultipart();
            MimeBodyPart html = new MimeBodyPart();
            html.setContent((Object)mailInfo.getContent(), "text/html; charset=utf-8");
            mainPart.addBodyPart((BodyPart)html);
            mailMessage.setContent((Multipart)mainPart);
            Transport.send((Message)mailMessage);
            return true;
        }
        catch (MessagingException ex) {
            ex.printStackTrace();
            return false;
        }
    }
}

