/*
 * Decompiled with CFR 0.152.
 */
package com.jz.common.utils.io;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.text.StringTools;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class FileTools {
    public static File loadFile(String path) {
        File file = new File(path);
        return file != null && file.exists() ? file : null;
    }

    public static List<String> getFilesPath(File file) {
        ArrayList<String> files = new ArrayList<String>();
        FileTools.getFilesPath(file, true, files);
        return files;
    }

    public static List<String> getFilesPath(File file, boolean subfolder) {
        ArrayList<String> files = new ArrayList<String>();
        FileTools.getFilesPath(file, subfolder, files);
        return files;
    }

    private static void getFilesPath(File file, boolean subfolder, List<String> files) {
        if (file == null || !file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File children = fileArray[n2];
                if (subfolder) {
                    FileTools.getFilesPath(children, subfolder, files);
                } else if (children.isFile()) {
                    files.add(children.getPath());
                }
                ++n2;
            }
        } else {
            files.add(file.getPath());
        }
    }

    public static String getContents(String filename, String charSet) {
        if (StringTools.isEmpty((CharSequence)filename) || StringTools.isEmpty((CharSequence)charSet)) {
            return null;
        }
        StringBuffer output = new StringBuffer();
        try {
            FileInputStream is = new FileInputStream(filename);
            InputStreamReader file = new InputStreamReader((InputStream)is, charSet);
            BufferedReader buff = new BufferedReader(file);
            String lineSeparator = FileTools.lineSeparator();
            String line = null;
            while ((line = buff.readLine()) != null) {
                output.append(String.valueOf(line) + lineSeparator);
            }
            buff.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return output.toString();
    }

    public static String getContents(String filename, String charSet, String ... startFilters) {
        if (StringTools.isEmpty((CharSequence)filename) || StringTools.isEmpty((CharSequence)charSet) || ArrayMapTools.isEmpty(startFilters)) {
            return null;
        }
        StringBuffer output = new StringBuffer();
        try {
            FileInputStream is = new FileInputStream(filename);
            InputStreamReader file = new InputStreamReader((InputStream)is, charSet);
            BufferedReader buff = new BufferedReader(file);
            String lineSeparator = FileTools.lineSeparator();
            String line = null;
            block2: while ((line = buff.readLine()) != null) {
                String[] stringArray = startFilters;
                int n = startFilters.length;
                int n2 = 0;
                while (n2 < n) {
                    String start = stringArray[n2];
                    if (line.startsWith(start)) continue block2;
                    ++n2;
                }
                output.append(String.valueOf(line) + lineSeparator);
            }
            buff.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return output.toString();
    }

    public static String lineSeparator() {
        return System.getProperty("line.separator");
    }

    public static Boolean putContents(String filename, String contents, String charSet) {
        Boolean result = false;
        PrintWriter printWriter = null;
        try {
            try {
                printWriter = new PrintWriter(filename, charSet);
                printWriter.write(contents);
                printWriter.flush();
                result = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                if (printWriter != null) {
                    printWriter.close();
                }
                printWriter = null;
            }
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
            printWriter = null;
        }
        return result;
    }
}

