/*
 * Decompiled with CFR 0.152.
 */
package com.jz.common.utils.io;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.text.StringTools;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.lang3.ClassUtils;
import org.springframework.asm.ClassReader;

public class ClassTools {
    private static final String CLASS_SUFFIX = ".class";
    private static final String JAR_PROTOCOL = "jar";

    public static ClassLoader getDefaultClassLoader() {
        try {
            return Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable ex) {
            return ClassUtils.class.getClassLoader();
        }
    }

    public static List<URL> findResourcesForPackage(String ... packages) throws IOException {
        if (ArrayMapTools.isEmpty(packages)) {
            return new ArrayList<URL>();
        }
        HashSet<URL> urls = new HashSet<URL>();
        String[] stringArray = packages;
        int n = packages.length;
        int n2 = 0;
        while (n2 < n) {
            String _pack = stringArray[n2];
            urls.addAll(ClassTools.findResourcesForUrl(_pack.replace(".", "/")));
            ++n2;
        }
        return new ArrayList<URL>(urls);
    }

    public static List<URL> findResourcesForUrl(String location) throws IOException {
        if (location.startsWith("/")) {
            location = location.substring(1);
        }
        if (!location.endsWith("/")) {
            location = String.valueOf(location) + "/";
        }
        Enumeration<URL> resourceUrls = ClassTools.getDefaultClassLoader().getResources(location);
        ArrayList<URL> result = new ArrayList<URL>();
        while (resourceUrls.hasMoreElements()) {
            result.add(resourceUrls.nextElement());
        }
        return result;
    }

    public static List<URL> getClassUrlsForFiles(URL rootFileUrl) throws URISyntaxException, MalformedURLException {
        if (rootFileUrl == null) {
            return new ArrayList<URL>();
        }
        File rootFile = new File(rootFileUrl.toURI());
        ArrayList<URL> fileList = new ArrayList<URL>();
        if (rootFile.isFile() && rootFile.getName().endsWith(CLASS_SUFFIX)) {
            fileList.add(rootFile.toURI().toURL());
            return fileList;
        }
        if (!rootFile.isDirectory()) {
            return fileList;
        }
        File[] fileArray = rootFile.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                fileList.addAll(ClassTools.getClassUrlsForFiles(file.toURI().toURL()));
            } else if (file.isFile() && file.getName().endsWith(CLASS_SUFFIX)) {
                fileList.add(file.toURI().toURL());
            }
            ++n2;
        }
        return fileList;
    }

    public static List<URL> getClassUrlsForJar(URL jarUrl) throws IOException, ClassNotFoundException {
        if (jarUrl == null || !JAR_PROTOCOL.equals(jarUrl.getProtocol())) {
            return new ArrayList<URL>();
        }
        ArrayList<URL> result = new ArrayList<URL>();
        URLConnection con = jarUrl.openConnection();
        JarURLConnection jarCon = (JarURLConnection)con;
        jarCon.setUseCaches(false);
        JarFile jarFile = jarCon.getJarFile();
        JarEntry jarEntry = jarCon.getJarEntry();
        String rootEntryPath = StringTools.ternary(jarEntry != null, jarEntry.getName(), "");
        if (!"".equals(rootEntryPath) && !rootEntryPath.endsWith("/")) {
            rootEntryPath = String.valueOf(rootEntryPath) + "/";
        }
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String entryPath = entry.getName();
            if (!entryPath.startsWith(rootEntryPath) || !entryPath.endsWith(CLASS_SUFFIX)) continue;
            result.add(ClassTools.createRelative(jarUrl, entryPath.substring(rootEntryPath.length())));
        }
        return result;
    }

    private static URL createRelative(URL url, String relativePath) throws MalformedURLException {
        if (relativePath.startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        return new URL(url, relativePath);
    }

    public static String getClassName(URL url) throws IOException {
        if (url == null) {
            return null;
        }
        InputStream is = url.openConnection().getInputStream();
        ClassReader classReader = new ClassReader(is);
        return classReader.getClassName().replace("/", ".");
    }

    public static Class<?> getClass(URL url) throws IOException, ClassNotFoundException {
        return ClassTools.getDefaultClassLoader().loadClass(ClassTools.getClassName(url));
    }

    public static boolean isWithAnnotation(URL url, Class<? extends Annotation> annotationClass) throws ClassNotFoundException, IOException {
        return ClassTools.getClass(url).isAnnotationPresent(annotationClass);
    }

    public static <T extends Annotation> T getAnnotation(URL url, Class<T> t) throws ClassNotFoundException, IOException {
        return ClassTools.getClass(url).getAnnotation(t);
    }
}

