package com.jz.common.utils.text;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

import com.jz.common.utils.security.EncryptionTools;

public class StringCondense64Tools {

	private final static char[] base = new char[] { 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm',
			'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7',
			'8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S',
			'T', 'U', 'V', 'W', 'X', 'Y', 'Z' };

	public final static String condense(String uid) {
		String _temp = uid + "/" + System.currentTimeMillis();
		try {
			return condense(_temp.getBytes());
		} catch (NoSuchAlgorithmException e) {
			return EncryptionTools.MD5(_temp);
		}
	}

	public final static String condense(byte[] data) throws NoSuchAlgorithmException {
		StringBuilder sb = new StringBuilder();
		for (byte b : MessageDigest.getInstance("MD5").digest(data)) {
			sb.append(base[Byte.toUnsignedInt(b) % 62]);
		}
		return sb.toString();
	}
	
}
