/*
 * Decompiled with CFR 0.152.
 */
package com.jz.common.utils.http;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.http.ConnectTools;
import com.jz.common.utils.text.StringTools;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectGet {
    private static Logger logger = LoggerFactory.getLogger(ConnectGet.class);
    private static final int default_life_time = 10000;
    private static final int default_time_out = 5000;

    public static String send(String url) throws ClientProtocolException, IOException {
        return ConnectGet.send(url, true);
    }

    public static String send(String url, boolean showLog) throws ClientProtocolException, IOException {
        return ConnectGet.send(url, "UTF-8", showLog);
    }

    public static String send(String url, String charsetName) throws ClientProtocolException, IOException {
        return ConnectGet.send(url, charsetName, true);
    }

    public static String send(String url, String charsetName, boolean showLog) throws ClientProtocolException, IOException {
        return ConnectGet.send(url, null, charsetName, null, showLog);
    }

    public static String send(String url, String params, String charsetName) throws ClientProtocolException, IOException {
        return ConnectGet.send(url, params, charsetName, true);
    }

    public static String send(String url, String params, String charsetName, boolean showLog) throws ClientProtocolException, IOException {
        return ConnectGet.send(url, params, charsetName, null, showLog);
    }

    public static String send(String url, String params, String charsetName, Map<String, String> header) throws ClientProtocolException, IOException {
        return ConnectGet.send(url, params, charsetName, header, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String send(String url, String params, String charsetName, Map<String, String> header, boolean showLog) throws ClientProtocolException, IOException {
        if (showLog) {
            logger.info("URL = {},Parameters = {}", (Object)url, (Object)params);
        }
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        httpClientBuilder.setConnectionTimeToLive(10000L, TimeUnit.MILLISECONDS);
        String result = null;
        try (CloseableHttpClient closeableHttpClient = httpClientBuilder.build();){
            String _temp;
            CloseableHttpResponse response;
            String charset;
            if (StringTools.isNotEmpty((CharSequence)params) && StringTools.isNotBlank((CharSequence)params)) {
                url = url + (url.indexOf("?") > 0 ? "&" : "?") + params;
            }
            HttpGet get = new HttpGet(url);
            get.setConfig(RequestConfig.custom().setSocketTimeout(5000).setConnectTimeout(5000).build());
            get.setHeader("accept", "*/*");
            get.setHeader("connection", "keep-alive");
            get.setHeader("user-agent", "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:38.0) Gecko/20100101 Firefox/38.0");
            if (ArrayMapTools.isNotEmpty(header)) {
                for (Map.Entry<String, String> entry : header.entrySet()) {
                    get.setHeader(entry.getKey(), entry.getValue());
                }
            }
            charsetName = StringTools.isNotEmpty((CharSequence)(charset = ConnectTools.getCharsetFromResponse((HttpResponse)(response = closeableHttpClient.execute((HttpUriRequest)get))))) ? charset : charsetName;
            String string = _temp = null != response.getEntity() ? EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Charset.forName(charsetName)) : null;
            if (showLog) {
                logger.info("CODE : {} || Result = {}", (Object)response.getStatusLine().getStatusCode(), (Object)_temp);
            }
            if (200 == response.getStatusLine().getStatusCode() && StringTools.isNotEmpty((CharSequence)_temp)) {
                result = _temp;
            }
        }
        return result;
    }

    public static String send(String url, Map<String, String> params) throws ClientProtocolException, IOException {
        return ConnectGet.send(url, params, "UTF-8");
    }

    public static String send(String url, Map<String, String> params, String charsetName) throws ClientProtocolException, IOException {
        return ConnectGet.send(url, params, charsetName, null);
    }

    public static String send(String url, Map<String, String> params, String charsetName, Map<String, String> header) throws ClientProtocolException, IOException {
        StringBuilder sb = new StringBuilder();
        if (ArrayMapTools.isNotEmpty(params)) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                sb.append(entry.getKey()).append("=").append(URLEncoder.encode(entry.getValue(), charsetName)).append("&");
            }
            sb.delete(sb.length() - 1, sb.length());
        }
        return ConnectGet.send(url, sb.toString(), charsetName, header, true);
    }
}

