package com.jz.common.utils.collection;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

import com.google.common.collect.Lists;

public class OrderTool {

	public static <T, O> List<T> keepOrder(Collection<O> orderList, Collection<T> toBeKeep, Function<T, O> keyMapper) {
		List<T> sorted = Lists.newArrayList();
		Map<O, T> map = toBeKeep.stream().collect(Collectors.toMap(keyMapper, o -> o, (u, v) -> u));
		orderList.stream().forEach(key -> {
			if (map.containsKey(key))
				sorted.add(map.get(key));
		});
		return sorted;
	}

}
