package com.jz.common.utils.other;

import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import com.jz.common.utils.text.StringTools;

/**
 * 语法简化<br/>
 * 如 替代System.out
 * 
 * @ClassName Me
 * @author Administrator
 * @date 2015年6月12日 下午3:17:30
 *
 */
public class Me {

	private Me() {
		// 禁用构造函数
	}

	/** 延时关闭JVM进程 */
	public static void delayExitSystem(final int seconds) {
		new Thread(new Runnable() {
			public void run() {
				try {
					Thread.sleep(seconds * 1000);
				} catch (Exception e) {
					e.printStackTrace();
				}
				System.exit(0);
			}
		}).start();
	}

	/**
	 * 运行Shell脚本
	 * 
	 * @param shell
	 */
	public static void execShell(String shell) {
		try {
			Runtime.getRuntime().exec(shell);
		} catch (Exception e) {
			// e.printStackTrace();
		}
	}

	/**
	 * 取得当前进程ID(用于Windows平台，Linux平台待测)
	 * 
	 * @return
	 */
	public static long getPID() {
		String processName = ManagementFactory.getRuntimeMXBean().getName();
		return Long.parseLong(processName.split("@")[0]);
	}

	/**
	 * 写入异常对象到文件中
	 * 
	 * @param filename
	 * @param e
	 */
	public static void writeException(String filename, Exception exception) {
		PrintWriter printWriter = null;
		try {
			printWriter = new PrintWriter(new FileWriter(filename, true));
			printWriter.write(new Date().toString() + ", ");
			exception.printStackTrace(printWriter);
		} catch (Exception ex) {
			// ex.printStackTrace();
		}
		if (null != printWriter) {
			printWriter.close();
		}
		printWriter = null;
	}

	/**
	 * 取得异常对象的StackTrace信息
	 * 
	 * @param e
	 * @return
	 */
	public static String getStackTrace(Exception e) {
		Writer w = new StringWriter();
		e.printStackTrace(new PrintWriter(w));
		return w.toString();
	}

	/**
	 * 取得当前进程的JVM内存使用情况
	 * 
	 * @return
	 */
	public static Map<String, Object> getJVMMemory() {
		Map<String, Object> map = new HashMap<String, Object>();
		Runtime runtime = Runtime.getRuntime();
		map.put("JVMFreeMemory", runtime.freeMemory());
		map.put("JVMMaxMemory", runtime.maxMemory());
		map.put("JVMTotalMemory", runtime.totalMemory());
		return map;
	}

	public static void printf(String format, Object... x) {
		System.out.printf(format, x);
	}

	public static void println(Object... x) {
		for (Object o : x) {
			System.out.print(o);
		}
		System.out.println();
	}

	public static void println(Object x) {
		// 数组
		if (null != x && x.getClass().isArray()) {
			System.out.println(StringTools.toString((Object[]) x));
		} else
			System.out.println(x);
	}

	public static void println() {
		System.out.println();
	}

	public static void print(Object x) {
		// 数组
		if (null != x && x.getClass().isArray()) {
			System.out.print(StringTools.toString((Object[]) x));
		} else
			System.out.print(x);
	}

	public static void exit(int status) {
		System.exit(status);
	}

}
