package com.jz.common.utils.number;

import java.util.Map;

import com.google.common.collect.Maps;

/**
 * @Title CustomNumberConvertTool
 * @Package com.jz.common.utils.number
 * @author tangjunfeng
 * @date 2018年8月29日 下午3:30:01
 * @version V1.0
 */
public class CustomNumberConvertTool {
	
	private static Map<Class<? extends Number>, NumberConvert<? extends Number>> class2Convert = Maps.newHashMap();
	
	static {
		// int
		class2Convert.put(Integer.class, new IntConvert());
		class2Convert.put(int.class, class2Convert.get(Integer.class));
		// long
		class2Convert.put(Long.class, new LongConvert());
		class2Convert.put(long.class, class2Convert.get(Long.class));
		// float
		class2Convert.put(Float.class, new FloatConvert());
		class2Convert.put(float.class, class2Convert.get(Float.class));
		// double
		class2Convert.put(Double.class, new DoubleConvert());
		class2Convert.put(double.class, class2Convert.get(Double.class));
	}

	@SuppressWarnings("unchecked")
	public static <T extends Number> T convert(Class<T> clazz, String value) {
		return ((NumberConvert<T>) class2Convert.get(clazz)).parse(value);
	}

	private static class IntConvert implements NumberConvert<Integer> {
		@Override
		public Integer parse(String value) {
			return Integer.parseInt(value);
		}
	}

	private static class LongConvert implements NumberConvert<Long> {
		@Override
		public Long parse(String value) {
			return Long.parseLong(value);
		}
	}
	
	private static class FloatConvert implements NumberConvert<Float> {
		@Override
		public Float parse(String value) {
			return Float.parseFloat(value);
		}
	}
	
	private static class DoubleConvert implements NumberConvert<Double> {
		@Override
		public Double parse(String value) {
			return Double.parseDouble(value);
		}
	}
}
