package com.jz.common.utils.collection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Map.Entry;

@SuppressWarnings({ "rawtypes", "unchecked" })
public class MapComparator {

	public enum Order {
		ASC, DESC;
	}

	public static Map softValue(Map<String, Integer> map, Order order) {
		if (order == null)
			order = Order.ASC;
		ArrayList<Entry<String, Integer>> list = new ArrayList<Entry<String, Integer>>(map.entrySet());
		Collections.sort(list, new Comparator<Entry<String, Integer>>() {
			@Override
			public int compare(Entry<String, Integer> arg0, Entry<String, Integer> arg1) {
				return arg0.getValue() - arg1.getValue();
			}
		});
		Map resultMap = new LinkedHashMap();
		if (order.equals(Order.ASC)) {
			for (int i = 0; i < list.size(); i++)
				resultMap.put(list.get(i).getKey(), list.get(i).getValue());
		} else {
			for (int i = list.size() - 1; i >= 0; i--)
				resultMap.put(list.get(i).getKey(), list.get(i).getValue());
		}
		return resultMap;
	}
}