package com.jz.common.utils.jz;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

import com.jz.common.utils.security.EncryptionTools;

/**
 * @Title VideoTools.java
 * @Package com.waqu.common.utils.text
 * @author tangjunfeng
 * @date 2016年3月19日 下午4:11:23
 * @version V1.0
 */
public class IdTools {

	private final static char[] base = new char[] { 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm',
			'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7',
			'8', '9' };
	
	public final static String noChangeEncode(String uid) {
		try {
			return encode(uid.getBytes());
		} catch (NoSuchAlgorithmException e) {
			return EncryptionTools.MD5(uid);
		}
	}
	
	public final static String encode(String uid) {
		String _temp = uid + "/" + System.currentTimeMillis();
		try {
			return encode(_temp.getBytes());
		} catch (NoSuchAlgorithmException e) {
			return EncryptionTools.MD5(_temp);
		}
	}
	
	public final static String encode(byte[] data) throws NoSuchAlgorithmException {
		StringBuilder sb = new StringBuilder();
		for (byte b : MessageDigest.getInstance("MD5").digest(data)) {
			sb.append(base[Byte.toUnsignedInt(b) % 36]);
		}
		return sb.toString();
	}

}
