/*
 * Decompiled with CFR 0.152.
 */
package com.jz.common.utils.other;

import java.util.Map;
import java.util.Objects;
import java.util.Random;

public class WeightRandom {
    private static final Random random = new Random();

    public static String calculate(Map<String, Integer> weightMaps) {
        Objects.requireNonNull(weightMaps);
        int[] weightArray = new int[weightMaps.size() + 1];
        String[] tempElementArray = new String[weightMaps.size()];
        int i = 0;
        for (Map.Entry<String, Integer> entry : weightMaps.entrySet()) {
            tempElementArray[i] = entry.getKey();
            weightArray[i + 1] = entry.getValue() + weightArray[i];
            ++i;
        }
        int totalWeight = weightArray[weightArray.length - 1];
        if (totalWeight <= 0) {
            return tempElementArray[0];
        }
        int randomNum = random.nextInt(totalWeight);
        int index = WeightRandom.half(weightArray, randomNum);
        return index == -1 ? null : tempElementArray[index];
    }

    private static int half(int[] desArray, int des) {
        int lowIndex = 0;
        int highIndex = desArray.length - 1;
        while (lowIndex <= highIndex) {
            int middle = (lowIndex + highIndex) / 2;
            if (des > desArray[middle] && des <= desArray[middle + 1]) {
                return middle;
            }
            if (des < desArray[middle]) {
                highIndex = middle - 1;
                continue;
            }
            lowIndex = middle + 1;
        }
        return -1;
    }
}

