/*
 * Decompiled with CFR 0.152.
 */
package com.jz.common.utils.number;

import com.google.common.collect.Maps;
import com.jz.common.utils.number.NumberConvert;
import java.util.Map;

public class CustomNumberConvertTool {
    private static Map<Class<? extends Number>, NumberConvert<? extends Number>> class2Convert = Maps.newHashMap();

    public static <T extends Number> T convert(Class<T> clazz, String value) {
        return (T)class2Convert.get(clazz).parse(value);
    }

    static {
        class2Convert.put(Integer.class, new IntConvert());
        class2Convert.put(Integer.TYPE, class2Convert.get(Integer.class));
        class2Convert.put(Long.class, new LongConvert());
        class2Convert.put(Long.TYPE, class2Convert.get(Long.class));
        class2Convert.put(Float.class, new FloatConvert());
        class2Convert.put(Float.TYPE, class2Convert.get(Float.class));
        class2Convert.put(Double.class, new DoubleConvert());
        class2Convert.put(Double.TYPE, class2Convert.get(Double.class));
    }

    private static class DoubleConvert
    implements NumberConvert<Double> {
        private DoubleConvert() {
        }

        @Override
        public Double parse(String value) {
            return Double.parseDouble(value);
        }
    }

    private static class FloatConvert
    implements NumberConvert<Float> {
        private FloatConvert() {
        }

        @Override
        public Float parse(String value) {
            return Float.valueOf(Float.parseFloat(value));
        }
    }

    private static class LongConvert
    implements NumberConvert<Long> {
        private LongConvert() {
        }

        @Override
        public Long parse(String value) {
            return Long.parseLong(value);
        }
    }

    private static class IntConvert
    implements NumberConvert<Integer> {
        private IntConvert() {
        }

        @Override
        public Integer parse(String value) {
            return Integer.parseInt(value);
        }
    }
}

