/*
 * Decompiled with CFR 0.152.
 */
package com.jz.common.utils.collection;

import com.jz.common.utils.collection.AbstractMapTools;
import com.jz.common.utils.text.StringTools;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ArrayMapTools
extends AbstractMapTools {
    public static boolean isEmpty(String[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isNotEmpty(String[] array) {
        return !ArrayMapTools.isEmpty(array);
    }

    public static boolean isEmpty(Collection collection) {
        return null == collection || collection.size() <= 0;
    }

    public static boolean isNotEmpty(Collection collection) {
        return !ArrayMapTools.isEmpty(collection);
    }

    public static boolean moreThan(Map<?, ?> map, int min) {
        return ArrayMapTools.isNotEmpty(map) && map.size() > min;
    }

    public static boolean moreThan(Collection<?> collection, int min) {
        return ArrayMapTools.isNotEmpty(collection) && collection.size() > min;
    }

    public static boolean lessThan(Map<?, ?> map, int max) {
        return ArrayMapTools.isNotEmpty(map) && map.size() < max;
    }

    public static boolean lessThan(Collection<?> collection, int max) {
        return ArrayMapTools.isNotEmpty(collection) && collection.size() < max;
    }

    public static boolean equal(Map<?, ?> map, int size) {
        return ArrayMapTools.isNotEmpty(map) && map.size() == size;
    }

    public static boolean equal(Collection<?> collection, int size) {
        return ArrayMapTools.isNotEmpty(collection) && collection.size() == size;
    }

    public static boolean equal(Object[] args, int size) {
        return ArrayMapTools.isNotEmpty((Object[])args) && args.length == size;
    }

    public static boolean allEmpty(Collection ... collections) {
        if (null != collections && collections.length > 0) {
            for (Collection coll : collections) {
                if (!ArrayMapTools.isNotEmpty(coll)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean allEmpty(Map ... maps) {
        if (null != maps && maps.length > 0) {
            for (Map map : maps) {
                if (!ArrayMapTools.isNotEmpty(map)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean allNotEmpty(Collection ... collections) {
        if (null != collections && collections.length > 0) {
            for (Collection coll : collections) {
                if (!ArrayMapTools.isEmpty(coll)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean allNotEmpty(Map ... maps) {
        if (null != maps && maps.length > 0) {
            for (Map map : maps) {
                if (!ArrayMapTools.isEmpty(map)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean containsEmpty(Collection ... collections) {
        if (null != collections && collections.length > 0) {
            for (Collection coll : collections) {
                if (!ArrayMapTools.isEmpty(coll)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsNotEmpty(Collection ... collections) {
        if (null != collections && collections.length > 0) {
            for (Collection coll : collections) {
                if (!ArrayMapTools.isNotEmpty(coll)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsEmpty(Map ... maps) {
        if (null != maps && maps.length > 0) {
            for (Map map : maps) {
                if (!ArrayMapTools.isEmpty(map)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsNotEmpty(Map ... maps) {
        if (null != maps && maps.length > 0) {
            for (Map map : maps) {
                if (!ArrayMapTools.isNotEmpty(map)) continue;
                return true;
            }
        }
        return false;
    }

    public static Collection containsExt(String key, Map<String, ?> map, Collection coll) {
        if (map.containsKey(key)) {
            Object obj = map.get(key);
            if (obj instanceof Collection) {
                coll.addAll((Collection)obj);
            } else {
                coll.add(map.get(key));
            }
        }
        return coll;
    }

    public static boolean allContainsKey(String key, Map ... maps) {
        if (ArrayMapTools.isEmpty((Object[])maps)) {
            return false;
        }
        for (Map m : maps) {
            if (m.containsKey(key)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsKey(String key, Map ... maps) {
        if (ArrayMapTools.isEmpty((Object[])maps)) {
            return false;
        }
        for (Map m : maps) {
            if (!m.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsKeys(Map maps, String ... keys) {
        if (ArrayMapTools.isEmpty(maps) || ArrayMapTools.isEmpty(keys)) {
            return false;
        }
        for (String k : keys) {
            if (maps.containsKey(k)) continue;
            return false;
        }
        return true;
    }

    public static <T extends Collection> List<T> limit(T t, int size) {
        ArrayList<Collection> arr = new ArrayList<Collection>();
        if (t.size() <= size) {
            arr.add(t);
            return arr;
        }
        try {
            Class<?> clazz = t.getClass();
            Collection coll = null;
            HashSet<Object> in = new HashSet<Object>();
            Object[] os = t.toArray();
            for (int i = 0; i < os.length; ++i) {
                in.add(os[i]);
                if (in.size() != size && i != os.length - 1) continue;
                coll = (Collection)clazz.newInstance();
                coll.addAll(in);
                arr.add(coll);
                in.clear();
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            return null;
        }
        return arr;
    }

    public static boolean isNotEmptyValues(Map maps, Enum ... keys) {
        if (ArrayMapTools.isEmpty(maps) || ArrayMapTools.isEmpty((Object[])keys)) {
            return false;
        }
        for (Enum e : keys) {
            if (maps.containsKey(e.name()) && null != maps.get(e.name())) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotEmptyValues(Map maps, String ... keys) {
        if (ArrayMapTools.isEmpty(maps) || ArrayMapTools.isEmpty(keys)) {
            return false;
        }
        for (String k : keys) {
            if (maps.containsKey(k) && null != maps.get(k)) continue;
            return false;
        }
        return true;
    }

    public static boolean isArray(Object arg0) {
        if (null != arg0) {
            if (arg0 instanceof Collection) {
                return true;
            }
            return arg0.getClass().isArray();
        }
        return false;
    }

    public static List getArray(Object arg0) {
        return ArrayMapTools.getArray(arg0, null);
    }

    public static List getArray(Object arg0, List array) {
        if (null != arg0 && ArrayMapTools.isArray(arg0)) {
            if (ArrayMapTools.isEmpty(array)) {
                array = new ArrayList<Object>();
            }
            if (arg0 instanceof Collection) {
                List list = (List)arg0;
                array.addAll(list);
                return array;
            }
            if (arg0.getClass().isArray()) {
                for (int i = 0; i < Array.getLength(arg0); ++i) {
                    array.add(Array.get(arg0, i));
                }
                return array;
            }
        }
        return null;
    }

    public static <E> E get(E[] args, int index) {
        if (ArrayMapTools.isEmpty((Object[])args)) {
            return null;
        }
        return args.length >= index ? (E)args[index] : null;
    }

    public static <E> E getNullMax(E[] args, int index) {
        if (ArrayMapTools.isEmpty((Object[])args)) {
            return null;
        }
        return args.length >= index ? args[index] : args[args.length - 1];
    }

    public static <E> E getNullMin(E[] args, int index) {
        if (ArrayMapTools.isEmpty((Object[])args)) {
            return null;
        }
        return args.length >= index ? args[index] : args[0];
    }

    public static String getString(Map<String, Object> map, String key) {
        if (ArrayMapTools.isEmpty(map)) {
            return null;
        }
        return StringTools.toString(map.get(key));
    }

    public static String getString(Map<String, Object> map, Enum key) {
        if (ArrayMapTools.isEmpty(map)) {
            return null;
        }
        return StringTools.toString(map.get(key.name()));
    }

    public static String getString(Map<String, Object> map, String key, String defaultValue) {
        if (ArrayMapTools.isEmpty(map)) {
            return defaultValue;
        }
        return StringTools.ternary(map.get(key), defaultValue);
    }

    public static String getString(Map<String, Object> map, Enum key, String defaultValue) {
        if (ArrayMapTools.isEmpty(map)) {
            return defaultValue;
        }
        return StringTools.ternary(map.get(key.name()), defaultValue);
    }

    public static boolean containsAll(Properties properties, String ... keys) {
        for (String k : keys) {
            if (properties.containsKey(k) && !StringTools.isEmpty((CharSequence)properties.getProperty(k))) continue;
            return false;
        }
        return true;
    }

    public static boolean contains(Properties properties, String ... keys) {
        for (String k : keys) {
            if (!properties.containsKey(k) || !StringTools.isNotEmpty((CharSequence)properties.getProperty(k))) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(List<String> args, String ... arg) {
        for (String ar : arg) {
            if (!args.contains(ar)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(List<String> args, List<String> arg) {
        for (String ar : arg) {
            if (!args.contains(ar)) continue;
            return true;
        }
        return false;
    }

    public static Object ternary(List<?> objs) {
        return ArrayMapTools.isEmpty(objs) ? null : objs;
    }

    public static Object ternary(List<?> objs, Object defaultValue) {
        return ArrayMapTools.isEmpty(objs) ? defaultValue : objs;
    }

    public static String[] replaceEmpty(String[] args, String defaultValue) {
        if (ArrayMapTools.isEmpty(args)) {
            return new String[]{defaultValue};
        }
        for (int i = args.length - 1; i >= 0; --i) {
            args[i] = StringTools.isNotEmpty((CharSequence)args[i]) ? args[i] : defaultValue;
        }
        return args;
    }

    public static <T> T getFirst(Collection<T> args) {
        return ArrayMapTools.isEmpty(args) ? null : (T)args.iterator().next();
    }
}

