/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.business.proxy.common;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.collection.OrderTool;
import com.jz.jar.business.card.ItemCard;
import com.jz.jar.business.request.VideoRequest;
import com.jz.jar.business.tool.VideoTool;
import com.jz.jar.business.wrapper.VideoWrapper;
import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.enums.SourceStatus;
import com.jz.jar.media.service.UploadVideoScoreService;
import com.jz.jar.media.service.UploadVideoService;
import com.jz.jooq.media.tables.pojos.UploadVideo;
import com.jz.jooq.media.tables.pojos.UploadVideoScore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class UploadVideoProxy {
    @Autowired
    private UploadVideoService uploadVideoService;
    @Autowired
    private UploadVideoScoreService uploadVideoScoreService;

    public boolean isStudentUploadVideo(String wid) {
        return wid.startsWith("sv_");
    }

    public int countVideoForUid(String uid, BrandEnum brand, List<SourceStatus> status) {
        return this.uploadVideoService.countVideos(uid, status, brand);
    }

    public List<ItemCard> getVideosForUid(String uid, BrandEnum brand, List<SourceStatus> status, int start, int size) {
        List wids = this.uploadVideoService.getVideos(uid, status, brand, start, size);
        if (ArrayMapTools.isEmpty((Collection)wids)) {
            return null;
        }
        return this.packageVideoCard(VideoRequest.of(uid, wids));
    }

    public VideoWrapper packageVideoWrapper(UploadVideo video) {
        if (null == video) {
            return null;
        }
        VideoWrapper vw = VideoWrapper.of(video);
        if (SourceStatus.online.getCode() == video.getStatus().intValue()) {
            VideoTool.getVideoUrl(video, vw);
            VideoTool.getSnapshotUrl(video.getUid(), video, vw);
            return vw;
        }
        VideoTool.getUploadVideoDefault(vw);
        return vw;
    }

    public VideoWrapper packageVideoWrapper(String uid, UploadVideo video) {
        VideoWrapper vw = VideoWrapper.of(video);
        if (SourceStatus.online.getCode() == video.getStatus().intValue()) {
            VideoTool.getVideoUrl(video, vw);
            VideoTool.getSnapshotUrl(uid, video, vw);
            return vw;
        }
        VideoTool.getUploadVideoDefault(vw);
        return vw;
    }

    public List<ItemCard> packageVideoCard(VideoRequest request) {
        if (ArrayMapTools.isEmpty(request.getWids())) {
            return null;
        }
        List videos = this.uploadVideoService.getVideoInfo(request.getWids());
        if (ArrayMapTools.isEmpty((Collection)videos)) {
            return null;
        }
        return this.packageVideoCard(request.getUid(), OrderTool.keepOrder(request.getWids(), (Collection)videos, UploadVideo::getWid));
    }

    public List<ItemCard> packageVideoCard(String uid, List<UploadVideo> videos) {
        if (ArrayMapTools.isEmpty(videos)) {
            return null;
        }
        List wids = videos.stream().map(it -> it.getWid()).collect(Collectors.toList());
        List scoreList = this.uploadVideoScoreService.mutiGetVideoScores(wids);
        HashMap scoreMap = Maps.newHashMap();
        if (ArrayMapTools.isNotEmpty((Collection)scoreList)) {
            scoreList.forEach(it -> scoreMap.put(it.getWid(), it));
        }
        ArrayList rsList = Lists.newArrayList();
        for (UploadVideo uv : videos) {
            VideoWrapper wrapper = this.packageVideoWrapper(uid, uv);
            if (scoreMap.containsKey(uv.getWid())) {
                UploadVideoScore score = (UploadVideoScore)scoreMap.get(uv.getWid());
                wrapper.setScore(score.getScore());
                wrapper.setRemark(score.getRemark());
            }
            rsList.add(ItemCard.of(wrapper));
        }
        return rsList;
    }
}

