/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.business.card;

import com.jz.jar.business.enums.CardType;
import com.jz.jar.business.wrapper.ActivityWrapper;
import com.jz.jar.business.wrapper.CommentWrapper;
import com.jz.jar.business.wrapper.LessonFeedbackWrapper;
import com.jz.jar.business.wrapper.LessonWrapper;
import com.jz.jar.business.wrapper.LevelWrapper;
import com.jz.jar.business.wrapper.NewsInfoWrapper;
import com.jz.jar.business.wrapper.NoticeWrapper;
import com.jz.jar.business.wrapper.PlaylistWrapper;
import com.jz.jar.business.wrapper.TagWrapper;
import com.jz.jar.business.wrapper.TopicWrapper;
import com.jz.jar.business.wrapper.VideoWrapper;
import com.jz.jar.business.wrapper.WorksInfoWrapper;
import com.jz.jar.business.wrapper.WorksThemeWrapper;

public class ItemCard {
    private CardType type;
    private VideoWrapper video;
    private PlaylistWrapper playlist;
    private LevelWrapper level;
    private TopicWrapper topic;
    private NoticeWrapper notice;
    private LessonWrapper lesson;
    private LessonFeedbackWrapper lessonFb;
    private CommentWrapper comment;
    private WorksInfoWrapper works;
    private WorksThemeWrapper theme;
    private NewsInfoWrapper news;
    private ActivityWrapper activity;
    private TagWrapper tag;

    private ItemCard() {
    }

    private ItemCard(CardType type) {
        this.type = type;
    }

    public static ItemCard of() {
        return new ItemCard();
    }

    public static ItemCard of(VideoWrapper video) {
        return new ItemCard(CardType.video).setVideo(video);
    }

    public static ItemCard of(PlaylistWrapper playlist) {
        return new ItemCard(CardType.playlist).setPlaylist(playlist);
    }

    public static ItemCard of(LevelWrapper level) {
        return new ItemCard(CardType.level).setLevel(level);
    }

    public static ItemCard of(TopicWrapper topic) {
        return new ItemCard(CardType.topic).setTopic(topic);
    }

    public static ItemCard of(NoticeWrapper notice) {
        return new ItemCard(CardType.notice).setNotice(notice);
    }

    public static ItemCard ofSysNotify(NoticeWrapper notice) {
        return new ItemCard(CardType.sysNotify).setNotice(notice);
    }

    public static ItemCard of(LessonWrapper lesson) {
        return new ItemCard(CardType.lesson).setLesson(lesson);
    }

    public static ItemCard of(LessonFeedbackWrapper lessonFb) {
        return new ItemCard(CardType.lessonFb).setLessonFb(lessonFb);
    }

    public static ItemCard of(CommentWrapper comment) {
        return new ItemCard(CardType.comment).setComment(comment);
    }

    public static ItemCard of(WorksInfoWrapper works) {
        return new ItemCard(CardType.works).setWorks(works);
    }

    public static ItemCard of(WorksThemeWrapper theme) {
        return new ItemCard(CardType.theme).setTheme(theme);
    }

    public static ItemCard of(NewsInfoWrapper news) {
        return new ItemCard(CardType.news).setNews(news);
    }

    public static ItemCard of(TagWrapper tag) {
        return new ItemCard(CardType.tag).setTag(tag);
    }

    public CardType getType() {
        return this.type;
    }

    public ItemCard setType(CardType type) {
        this.type = type;
        return this;
    }

    public VideoWrapper getVideo() {
        return this.video;
    }

    public ItemCard setVideo(VideoWrapper video) {
        this.video = video;
        return this;
    }

    public PlaylistWrapper getPlaylist() {
        return this.playlist;
    }

    public ItemCard setPlaylist(PlaylistWrapper playlist) {
        this.playlist = playlist;
        return this;
    }

    public LevelWrapper getLevel() {
        return this.level;
    }

    public ItemCard setLevel(LevelWrapper level) {
        this.level = level;
        return this;
    }

    public TopicWrapper getTopic() {
        return this.topic;
    }

    public ItemCard setTopic(TopicWrapper topic) {
        this.topic = topic;
        return this;
    }

    public NoticeWrapper getNotice() {
        return this.notice;
    }

    public ItemCard setNotice(NoticeWrapper notice) {
        this.notice = notice;
        return this;
    }

    public LessonWrapper getLesson() {
        return this.lesson;
    }

    public ItemCard setLesson(LessonWrapper lesson) {
        this.lesson = lesson;
        return this;
    }

    public LessonFeedbackWrapper getLessonFb() {
        return this.lessonFb;
    }

    public ItemCard setLessonFb(LessonFeedbackWrapper lessonFb) {
        this.lessonFb = lessonFb;
        return this;
    }

    public CommentWrapper getComment() {
        return this.comment;
    }

    public ItemCard setComment(CommentWrapper comment) {
        this.comment = comment;
        return this;
    }

    public WorksInfoWrapper getWorks() {
        return this.works;
    }

    public ItemCard setWorks(WorksInfoWrapper works) {
        this.works = works;
        return this;
    }

    public WorksThemeWrapper getTheme() {
        return this.theme;
    }

    public ItemCard setTheme(WorksThemeWrapper theme) {
        this.theme = theme;
        return this;
    }

    public NewsInfoWrapper getNews() {
        return this.news;
    }

    public ItemCard setNews(NewsInfoWrapper news) {
        this.news = news;
        return this;
    }

    public ActivityWrapper getActivity() {
        return this.activity;
    }

    public ItemCard setActivity(ActivityWrapper activity) {
        this.activity = activity;
        return this;
    }

    public TagWrapper getTag() {
        return this.tag;
    }

    public ItemCard setTag(TagWrapper tag) {
        this.tag = tag;
        return this;
    }
}

