package com.jz.jar.business.request;

import java.util.Collection;

public class VideoRequest {
	private VideoRequest() {
	}

	private String uid;
	private String pid;
	private String wid;
	private Collection<String> wids;
	private Boolean withHistory = false;

	public static VideoRequest of(Collection<String> wids) {
		return new VideoRequest().setWids(wids);
	}

	public static VideoRequest of(String uid, Collection<String> wids) {
		return of(wids).setUid(uid);
	}
	
	public static VideoRequest of(String uid, String pid, Collection<String> wids) {
		return of(uid, wids).setPid(pid);
	}
	
	public static VideoRequest of(String uid, String pid, String wid) {
		return new VideoRequest().setUid(uid).setPid(pid).setWid(wid);
	}
	
	public String getUid() {
		return uid;
	}

	public VideoRequest setUid(String uid) {
		this.uid = uid;
		return this;
	}

	public String getPid() {
		return pid;
	}

	public VideoRequest setPid(String pid) {
		this.pid = pid;
		return this;
	}

	public String getWid() {
		return wid;
	}

	public VideoRequest setWid(String wid) {
		this.wid = wid;
		return this;
	}

	public Collection<String> getWids() {
		return wids;
	}

	public VideoRequest setWids(Collection<String> wids) {
		this.wids = wids;
		return this;
	}

	public Boolean getWithHistory() {
		return withHistory;
	}

	public VideoRequest setWithHistory(Boolean withHistory) {
		this.withHistory = withHistory;
		return this;
	}

}
