/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.business.proxy.common;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.business.bean.AliyunBean;
import com.jz.jar.business.enums.PictureCompress;
import com.jz.jar.business.wrapper.NewsInfoWrapper;
import com.jz.jar.business.wrapper.TopicWrapper;
import com.jz.jooq.website.tables.pojos.NewsInfo;
import com.jz.website.cache.ram.NewsTopicRAMCache;
import com.jz.website.service.NewsInfoService;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class NewsInfoProxy {
    @Autowired
    private NewsInfoService newsInfoService;

    public List<TopicWrapper> getChildrenTopic(Integer rootTopicId) {
        List children = NewsTopicRAMCache.getChildren((Integer)rootTopicId);
        if (ArrayMapTools.isEmpty((Collection)children)) {
            return null;
        }
        return children.stream().map(TopicWrapper::of).collect(Collectors.toList());
    }

    public int countNews(String school, Integer topicId) {
        return this.newsInfoService.cntNews(school, topicId);
    }

    public List<NewsInfoWrapper> getNews(String school, Integer topicId, int start, int size) {
        List newsId = this.newsInfoService.getNewsId(school, topicId, start, size);
        if (ArrayMapTools.isEmpty((Collection)newsId)) {
            return null;
        }
        List newsInfo = this.newsInfoService.getListNewsInfo(newsId);
        if (ArrayMapTools.isEmpty((Collection)newsInfo)) {
            return null;
        }
        return newsInfo.stream().map(it -> NewsInfoWrapper.of(it).setPic(AliyunBean.getImagesUrl(it.getPic(), PictureCompress._30))).collect(Collectors.toList());
    }

    public NewsInfo getNewsInfo(String nid) {
        return this.newsInfoService.getNewsInfo(nid);
    }
}

