package com.jz.jar.business.proxy.common;

import java.util.List;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.business.bean.AliyunBean;
import com.jz.jar.business.enums.PictureCompress;
import com.jz.jar.business.wrapper.NewsInfoWrapper;
import com.jz.jar.business.wrapper.TopicWrapper;
import com.jz.jooq.website.tables.pojos.NewsInfo;
import com.jz.jooq.website.tables.pojos.NewsTopic;
import com.jz.website.cache.ram.NewsTopicRAMCache;
import com.jz.website.service.NewsInfoService;

@Lazy
@Service
public class NewsInfoProxy {

	@Autowired
	private NewsInfoService newsInfoService;

	public List<TopicWrapper> getChildrenTopic(Integer rootTopicId) {
		// 获取所有的二级分类
		List<NewsTopic> children = NewsTopicRAMCache.getChildren(rootTopicId);
		if (ArrayMapTools.isEmpty(children))
			return null;
		return children.stream().map(TopicWrapper::of).collect(Collectors.toList());
	}

	public int countNews(String school, Integer topicId) {
		return newsInfoService.cntNews(school, topicId);
	}

	/** 获取资讯内容 */
	public List<NewsInfoWrapper> getNews(String school, Integer topicId, int start, int size) {
		// 获取资讯的id列表
		List<String> newsId = newsInfoService.getNewsId(school, topicId, start, size);
		if (ArrayMapTools.isEmpty(newsId))
			return null;
		// 获取资讯信息
		List<NewsInfo> newsInfo = newsInfoService.getListNewsInfo(newsId);
		if (ArrayMapTools.isEmpty(newsInfo))
			return null;
		// 图片路径
		return newsInfo.stream()
				.map(it -> NewsInfoWrapper.of(it)
						.setPic(AliyunBean.getImagesUrl(it.getPic(), PictureCompress._30)))
				.collect(Collectors.toList());
	}

	public NewsInfo getNewsInfo(String nid) {
		return newsInfoService.getNewsInfo(nid);
	}
}
