package com.jz.jar.business.proxy;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.enums.CtxType;
import com.jz.jar.media.service.UserNoticeService;
import com.jz.jooq.media.tables.records.UserNoticeRecord;

/**
 * @Title UserNoticeBusinessProxy
 * @Package com.jz.jar.business.proxy
 * @author tangjunfeng
 * @date 2019年1月22日 上午11:47:01
 * @version V1.0
 */
@Lazy
@Service
public class UserNoticeBusinessProxy {

	@Autowired
	private UserNoticeService userNoticeService;

	public void addFollow(BrandEnum brand, String uid, String relatedUid) {
		String title = "@" + relatedUid + " 关注了你";
		UserNoticeRecord record = new UserNoticeRecord();
		record.setBrand(brand.name());
		record.setUid(uid);
		record.setRelatedUid(relatedUid);
		record.setTitle(title);
		record.setCreated(System.currentTimeMillis());
		userNoticeService.addUserNotice(record);
	}
	
	public void addComment(BrandEnum brand, CtxType type, String sourceId, String uid, String relatedUid, String content, boolean isReply) {
		String title = "@" + relatedUid + (isReply ? " 回复了你的评论" : " 评论了你的宝宝作品");
		UserNoticeRecord record = new UserNoticeRecord();
		record.setBrand(brand.name());
		record.setUid(uid);
		record.setRelatedUid(relatedUid);
		record.setTitle(title);
		record.setContent(content);
		record.setSourceType(type.name());
		record.setSourceId(sourceId);
		record.setCreated(System.currentTimeMillis());
		userNoticeService.addUserNotice(record);
	}
	
	public void addLikeWorks(BrandEnum brand, String uid, String relatedUid, String artId) {
		String title = "@" + relatedUid + " 点赞了你的宝宝作品";
		UserNoticeRecord record = new UserNoticeRecord();
		record.setBrand(brand.name());
		record.setUid(uid);
		record.setRelatedUid(relatedUid);
		record.setTitle(title);
		record.setSourceType(CtxType.works.name());
		record.setSourceId(artId);
		record.setCreated(System.currentTimeMillis());
		userNoticeService.addUserNotice(record);
	}
	
}
