package com.jz.jar.business.request;

import com.jz.jar.media.enums.BrandEnum;

/**
 * @Title ReservationRequest
 * @Package com.jz.jar.business.request
 * @author tangjunfeng
 * @date 2018年11月20日 上午11:52:37
 * @version V1.0
 */
public class ReservationRequest {
	// 品牌
	private BrandEnum brand;
	// 用户标识
	private String uid;
	private String phone;
	// 所选校区
	private String schoolId;
	// 学员信息
	private String suid;
	private String name;
	private String sex;
	private String birthday;

	// 是否存在学员信息
	private Boolean isExistStudent;

	public static ReservationRequest of(BrandEnum brand, String uid, String schoolId) {
		return new ReservationRequest().setBrand(brand).setUid(uid).setSchoolId(schoolId).setIsExistStudent(false);
	}

	public ReservationRequest setStudentInfo(String suid, String name, String sex, String birthday) {
		return this.setSuid(suid).setName(name).setSex(sex).setBirthday(birthday).setIsExistStudent(true);
	}

	public BrandEnum getBrand() {
		return brand;
	}

	public ReservationRequest setBrand(BrandEnum brand) {
		this.brand = brand;
		return this;
	}

	public String getUid() {
		return uid;
	}

	public ReservationRequest setUid(String uid) {
		this.uid = uid;
		return this;
	}

	public String getPhone() {
		return phone;
	}

	public ReservationRequest setPhone(String phone) {
		this.phone = phone;
		return this;
	}

	public String getSchoolId() {
		return schoolId;
	}

	public ReservationRequest setSchoolId(String schoolId) {
		this.schoolId = schoolId;
		return this;
	}

	public String getSuid() {
		return suid;
	}

	public ReservationRequest setSuid(String suid) {
		this.suid = suid;
		return this;
	}

	public String getName() {
		return name;
	}

	public ReservationRequest setName(String name) {
		this.name = name;
		return this;
	}

	public String getSex() {
		return sex;
	}

	public ReservationRequest setSex(String sex) {
		this.sex = sex;
		return this;
	}

	public String getBirthday() {
		return birthday;
	}

	public ReservationRequest setBirthday(String birthday) {
		this.birthday = birthday;
		return this;
	}

	public Boolean getIsExistStudent() {
		return isExistStudent;
	}

	public ReservationRequest setIsExistStudent(Boolean isExistStudent) {
		this.isExistStudent = isExistStudent;
		return this;
	}

}
