/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.business.proxy;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.jz.IdTools;
import com.jz.common.utils.text.StringTools;
import com.jz.jar.business.proxy.ParentInfoBusinessProxy;
import com.jz.jar.business.request.ReservationRequest;
import com.jz.jar.business.response.ReservationResponse;
import com.jz.jar.franchise.service.FUserFlowNoticeService;
import com.jz.jar.franchise.service.FUserRoleService;
import com.jz.jar.franchise.service.MarketCasePoolService;
import com.jz.jar.franchise.service.ParentInfoService;
import com.jz.jar.franchise.service.SchoolService;
import com.jz.jar.franchise.service.StudentInfoService;
import com.jz.jar.franchise.wrapper.CaseChildWrapper;
import com.jz.jar.media.service.ReservationService;
import com.jz.jooq.franchise.tables.pojos.MarketCasePool;
import com.jz.jooq.franchise.tables.pojos.ParentInfo;
import com.jz.jooq.franchise.tables.pojos.School;
import com.jz.jooq.franchise.tables.pojos.StudentInfo;
import com.jz.jooq.franchise.tables.records.FuserFlowNoticeRecord;
import com.jz.jooq.media.tables.records.ReservationRecord;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class ReservationBusinessProxy {
    @Autowired
    private SchoolService schoolService;
    @Autowired
    private ParentInfoService parentInfoService;
    @Autowired
    private ReservationService reservationService;
    @Autowired
    private MarketCasePoolService marketCasePoolService;
    @Autowired
    private FUserFlowNoticeService fUserFlowNoticeService;
    @Autowired
    private FUserRoleService fUserRoleService;
    @Autowired
    private StudentInfoService studentInfoService;
    @Autowired
    private ParentInfoBusinessProxy parentInfoBusinessProxy;

    public ReservationResponse apply(ReservationRequest request) {
        School school = this.schoolService.getSchool(request.getSchoolId());
        if (null == school) {
            return ReservationResponse.failed("\u65e0\u6548\u7684\u4e2d\u5fc3");
        }
        ParentInfo parentInfo = null;
        if (StringTools.isNotEmptyAndBlank((String)request.getUid())) {
            parentInfo = this.parentInfoService.getParentInfoForId(request.getUid());
        } else if (StringTools.isNotEmptyAndBlank((String)request.getPhone())) {
            Pair<ParentInfo, Boolean> pair = this.parentInfoBusinessProxy.getOrCreateParentInfo(request.getPhone(), false);
            parentInfo = (ParentInfo)pair.getLeft();
        }
        if (null == parentInfo) {
            return ReservationResponse.failed("\u65e0\u6548\u7684\u7528\u6237");
        }
        if (this.reservationService.existValidReservation(parentInfo.getPuid(), school.getId())) {
            return ReservationResponse.exist();
        }
        this.saveReservation(request.getBrand(), parentInfo, school);
        HashSet fuids = Sets.newHashSet((Iterable)this.fUserRoleService.getEnableUidsByRole(school.getId(), (Collection)Lists.newArrayList((Object[])new String[]{"master", "fu_master"})));
        MarketCasePool mcp = this.marketCasePoolService.getMarketCaseByPhone(school.getId(), parentInfo.getPhone());
        String caseId = null;
        if (mcp == null) {
            caseId = this.createMarketCase(request, school, parentInfo);
        } else {
            caseId = mcp.getId();
            if (StringUtils.isNotEmpty((CharSequence)mcp.getAdviser())) {
                fuids.add(mcp.getAdviser());
            }
        }
        if (ArrayMapTools.isNotEmpty((Collection)fuids)) {
            ArrayList notices = Lists.newArrayList();
            String content = "\u624b\u673a\u53f7\u4e3a" + parentInfo.getPhone() + "\u7684\u7528\u6237\u9884\u7ea6\u7684\u60a8\u7684\u8bd5\u542c\uff0c\u8bf7\u5c3d\u5feb\u8054\u7cfb!";
            for (String fuid : fuids) {
                notices.add(new FuserFlowNoticeRecord(null, fuid, school.getId(), "marketCase", content, caseId, Long.valueOf(System.currentTimeMillis()), Integer.valueOf(0)));
            }
            this.fUserFlowNoticeService.mutiCreateNotice((Collection)notices);
        }
        return ReservationResponse.ok();
    }

    private String createMarketCase(ReservationRequest request, School school, ParentInfo parentInfo) {
        List sis = this.studentInfoService.getStudents(parentInfo.getPuid());
        ArrayList childs = Lists.newArrayList();
        if (request.getIsExistStudent().booleanValue()) {
            childs.add(CaseChildWrapper.of().setName(request.getName()).setSex(request.getSex()).setBirthday(request.getBirthday()));
        }
        if (ArrayMapTools.isNotEmpty((Collection)sis)) {
            for (StudentInfo si : sis) {
                childs.add(CaseChildWrapper.of((StudentInfo)si));
            }
        } else if (request.getIsExistStudent().booleanValue()) {
            this.studentInfoService.refreshStudent(parentInfo.getPuid(), IdTools.encode((String)parentInfo.getPuid()), request.getName(), null, request.getSex(), request.getBirthday(), null);
        }
        String caseId = IdTools.encode((String)parentInfo.getPuid());
        this.marketCasePoolService.createCase(caseId, "system", school.getId(), "app_yuyue", parentInfo.getPhone(), "", "", (List)childs, parentInfo.getName(), parentInfo.getRelation(), parentInfo.getAddress(), parentInfo.getDistrict(), "A", 0L);
        return caseId;
    }

    private void saveReservation(String brand, ParentInfo parentInfo, School school) {
        ReservationRecord record = new ReservationRecord();
        record.setBrand(brand);
        record.setUid(parentInfo.getPuid());
        record.setPhone(parentInfo.getPhone());
        record.setName(parentInfo.getName());
        record.setSchoolId(school.getId());
        record.setProv(school.getProv());
        record.setCenterName(school.getCenterName());
        record.setCenterAddress(school.getCenterAddress());
        record.setCenterType(this.getCenterType(school.getType()));
        record.setStatus(Integer.valueOf(1));
        record.setCreateTime(Long.valueOf(System.currentTimeMillis()));
        this.reservationService.saveRecord(record);
    }

    private String getCenterType(int type) {
        if (1 == type) {
            return "\u76f4\u8425";
        }
        if (2 == type) {
            return "\u52a0\u76df";
        }
        return "\u5176\u5b83";
    }
}

