package com.jz.jar.business.wrapper;

import java.util.List;

import com.google.common.collect.Lists;
import com.jz.jooq.media.tables.pojos.TomatoTheme;

public class HomeThemeWrapper {
	private HomeThemeWrapper() {
	}

	private String tid;
	private String name;
	private String bannerPic;
	private List<PlaylistWrapper> playlist;

	public static HomeThemeWrapper of(TomatoTheme theme) {
		return new HomeThemeWrapper().setTid(theme.getId()).setName(theme.getName());
	}

	public String getTid() {
		return tid;
	}

	public HomeThemeWrapper setTid(String tid) {
		this.tid = tid;
		return this;
	}

	public String getName() {
		return name;
	}

	public HomeThemeWrapper setName(String name) {
		this.name = name;
		return this;
	}

	public String getBannerPic() {
		return bannerPic;
	}

	public HomeThemeWrapper setBannerPic(String bannerPic) {
		this.bannerPic = bannerPic;
		return this;
	}

	public List<PlaylistWrapper> getPlaylist() {
		return playlist;
	}

	public HomeThemeWrapper setPlaylist(List<PlaylistWrapper> playlist) {
		this.playlist = playlist;
		return this;
	}

	public HomeThemeWrapper addPlaylist(PlaylistWrapper playlist) {
		if (null == playlist)
			return this;
		if (null == this.playlist)
			this.playlist = Lists.newArrayList();
		this.playlist.add(playlist);
		return this;
	}
}
