package com.jz.jar.search.entity.business.tomato;

import java.util.List;

import com.jz.jar.media.enums.PlaylistType;
import com.jz.jar.search.entity.base.AliOpenSearchBase;
import com.jz.jooq.media.tables.pojos.MediaVideo;
import com.jz.jooq.media.tables.pojos.Playlist;
import com.jz.jooq.media.tables.pojos.TomatoImageText;

public class ETomatoSearchBean extends AliOpenSearchBase {

	private String id;
	private String name;
	private Integer type;
	private Integer timer;
	private List<String> attrs;

	public static ETomatoSearchBean of(String id) {
		return new ETomatoSearchBean().setId(id);
	}

	public static ETomatoSearchBean of(Playlist playlist) {
		ETomatoSearchBean bean = new ETomatoSearchBean().setId(playlist.getPid()).setName(playlist.getName())
				.setTimer(playlist.getLastUpdate());
		if (PlaylistType.video.isEqualsName(playlist.getType())) {
			bean.setType(TomatoSearchType.video_playlist);
		} else {
			bean.setType(TomatoSearchType.img_txt_playlist);
		}
		return bean;
	}

	public static ETomatoSearchBean of(MediaVideo video) {
		return new ETomatoSearchBean().setId(video.getWid()).setName(video.getName()).setTimer(video.getLastUpdate())
				.setType(TomatoSearchType.video);
	}

	public static ETomatoSearchBean of(TomatoImageText imageText) {
		return new ETomatoSearchBean().setId(imageText.getId()).setName(imageText.getName())
				.setTimer(imageText.getLastUpdated()).setType(TomatoSearchType.img_txt);
	}

	public String getId() {
		return id;
	}

	public ETomatoSearchBean setId(String id) {
		this.id = id;
		return this;
	}

	public String getName() {
		return name;
	}

	public ETomatoSearchBean setName(String name) {
		this.name = name;
		return this;
	}

	public Integer getType() {
		return type;
	}

	public ETomatoSearchBean setType(TomatoSearchType type) {
		this.type = type.getCode();
		return this;
	}

	public Integer getTimer() {
		return timer;
	}

	public ETomatoSearchBean setTimer(Long timer) {
		this.timer = (int) (timer / 1000);
		return this;
	}

	public List<String> getAttrs() {
		return attrs;
	}

	public ETomatoSearchBean setAttrs(List<String> attrs) {
		this.attrs = attrs;
		return this;
	}

}
