package com.jz.jar.business.request;

import java.util.Collection;

public class ImgTxtRequest {
	private ImgTxtRequest() {
	}

	private String uid;
	private String pid;
	private String iid;
	private Collection<String> iids;

	private Boolean isWithCollect = false;

	public static ImgTxtRequest of(Collection<String> iids) {
		return new ImgTxtRequest().setIids(iids);
	}

	public static ImgTxtRequest of(String uid, Collection<String> iids) {
		return of(iids).setUid(uid);
	}

	public static ImgTxtRequest of(String uid, String pid, Collection<String> iids) {
		return of(uid, iids).setPid(pid);
	}

	public static ImgTxtRequest of(String uid, String pid, String iid) {
		return new ImgTxtRequest().setUid(uid).setPid(pid).setIid(iid);
	}

	public String getUid() {
		return uid;
	}

	public ImgTxtRequest setUid(String uid) {
		this.uid = uid;
		return this;
	}

	public String getPid() {
		return pid;
	}

	public ImgTxtRequest setPid(String pid) {
		this.pid = pid;
		return this;
	}

	public String getIid() {
		return iid;
	}

	public ImgTxtRequest setIid(String iid) {
		this.iid = iid;
		return this;
	}

	public Collection<String> getIids() {
		return iids;
	}

	public ImgTxtRequest setIids(Collection<String> iids) {
		this.iids = iids;
		return this;
	}

	public Boolean getIsWithCollect() {
		return isWithCollect;
	}

	public ImgTxtRequest setIsWithCollect(Boolean isWithCollect) {
		this.isWithCollect = isWithCollect;
		return this;
	}

}
