/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.business.proxy.common;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.business.bean.AliyunBean;
import com.jz.jar.business.enums.PictureCompress;
import com.jz.jar.business.wrapper.QuestionOptionWrapper;
import com.jz.jar.business.wrapper.QuestionWrapper;
import com.jz.jar.media.service.QuestionOptionService;
import com.jz.jar.media.service.QuestionService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class QuestionProxy {
    @Autowired
    private QuestionService questionService;
    @Autowired
    private QuestionOptionService questionOptionService;

    public List<QuestionWrapper> getQuestion(Collection<String> qids) {
        List questions = this.questionService.getQuestions(qids);
        if (ArrayMapTools.isEmpty((Collection)questions)) {
            return null;
        }
        Collections.shuffle(questions);
        Map<String, List<QuestionOptionWrapper>> qid2Options = this.getQuestionOptions(qids);
        ArrayList wrappers = Lists.newArrayList();
        questions.forEach(it -> {
            if (!qid2Options.containsKey(it.getQid())) {
                return;
            }
            QuestionWrapper qw = QuestionWrapper.of(it);
            wrappers.add(qw);
            qw.setAudio(AliyunBean.getImagesUrl(it.getAudio(), null)).setPic(AliyunBean.getImagesUrl(it.getPic(), PictureCompress._510x280));
            qw.setOptions((List)qid2Options.get(it.getQid()));
            Collections.shuffle(qw.getOptions());
        });
        return wrappers;
    }

    public Map<String, List<QuestionOptionWrapper>> getQuestionOptions(Collection<String> qids) {
        List options = this.questionOptionService.getQuestionOptions(qids);
        if (ArrayMapTools.isEmpty((Collection)options)) {
            return Maps.newHashMap();
        }
        HashMap qid2Options = Maps.newHashMap();
        options.forEach(it -> {
            QuestionOptionWrapper op = QuestionOptionWrapper.of(it);
            op.setPic(AliyunBean.getImagesUrl(it.getPic(), PictureCompress._510x280));
            if (!qid2Options.containsKey(it.getQid())) {
                qid2Options.put(it.getQid(), Lists.newArrayList());
            }
            ((List)qid2Options.get(it.getQid())).add(op);
        });
        return qid2Options;
    }
}

