package com.jz.jar.business.wrapper;

import com.jz.jar.business.bean.AliyunBean;
import com.jz.jooq.media.tables.pojos.TeacherInfo;

public class TeacherInfoWrapper {

	private String id;
	private String name;
	private String pic;
	private String proTitle;
	private String introduction;

	public static TeacherInfoWrapper of(TeacherInfo t) {
		return new TeacherInfoWrapper().setId(t.getId()).setName(t.getName()).setPic(t.getPic())
				.setProTitle(t.getProTitle()).setIntroduction(t.getIntroduction());
	}

	public String getId() {
		return id;
	}

	public TeacherInfoWrapper setId(String id) {
		this.id = id;
		return this;
	}

	public String getName() {
		return name;
	}

	public TeacherInfoWrapper setName(String name) {
		this.name = name;
		return this;
	}

	public String getPic() {
		return pic;
	}

	public TeacherInfoWrapper setPic(String pic) {
		this.pic = AliyunBean.getImagesUrl(pic);
		return this;
	}

	public String getProTitle() {
		return proTitle;
	}

	public TeacherInfoWrapper setProTitle(String proTitle) {
		this.proTitle = proTitle;
		return this;
	}

	public String getIntroduction() {
		return introduction;
	}

	public TeacherInfoWrapper setIntroduction(String introduction) {
		this.introduction = introduction;
		return this;
	}

}
