/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.business.proxy;

import com.google.common.collect.Lists;
import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.enums.DbField;
import com.jz.jar.media.service.UserNoticeService;
import com.jz.jooq.media.tables.records.UserNoticeRecord;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class UserNoticeBusinessProxy {
    @Autowired
    private UserNoticeService userNoticeService;

    public void addFollow(BrandEnum brand, String uid, String relatedUid) {
        String title = "@" + relatedUid + " \u5173\u6ce8\u4e86\u4f60";
        UserNoticeRecord record = new UserNoticeRecord();
        record.setBrand(brand.name());
        record.setUid(uid);
        record.setRelatedUid(relatedUid);
        record.setTitle(title);
        record.setCreated(Long.valueOf(System.currentTimeMillis()));
        this.userNoticeService.addUserNotice(new UserNoticeRecord[]{record});
    }

    public void addComment(BrandEnum brand, DbField type, String sourceId, List<String> uids, String relatedUid, String content, String attach, boolean isReply) {
        String title = "@" + relatedUid + (isReply ? " \u56de\u590d\u4e86\u4f60\u7684\u8bc4\u8bba" : " \u8bc4\u8bba\u4e86\u4f60\u7684\u5b9d\u5b9d\u4f5c\u54c1");
        ArrayList records = Lists.newArrayList();
        uids.forEach(_uid -> {
            UserNoticeRecord record = new UserNoticeRecord();
            record.setBrand(brand.name());
            record.setUid(_uid);
            record.setRelatedUid(relatedUid);
            record.setTitle(title);
            record.setContent(content);
            record.setSourceType(type.name());
            record.setSourceId(sourceId);
            record.setAttach(attach);
            record.setCreated(Long.valueOf(System.currentTimeMillis()));
            records.add(record);
        });
        UserNoticeRecord[] array = new UserNoticeRecord[]{};
        this.userNoticeService.addUserNotice(records.toArray(array));
    }

    public void addLikeWorks(BrandEnum brand, String uid, String relatedUid, String artId) {
        String title = "@" + relatedUid + " \u70b9\u8d5e\u4e86\u4f60\u7684\u5b9d\u5b9d\u4f5c\u54c1";
        UserNoticeRecord record = new UserNoticeRecord();
        record.setBrand(brand.name());
        record.setUid(uid);
        record.setRelatedUid(relatedUid);
        record.setTitle(title);
        record.setSourceType(DbField.works.name());
        record.setSourceId(artId);
        record.setCreated(Long.valueOf(System.currentTimeMillis()));
        this.userNoticeService.addUserNotice(new UserNoticeRecord[]{record});
    }
}

