package com.jz.jar.business.wrapper;

import java.util.List;

import org.apache.commons.lang3.StringUtils;

import com.google.common.collect.Lists;
import com.jz.jar.business.bean.AliyunBean;
import com.jz.jooq.media.tables.pojos.TomatoCourseAudio;

/**
 * @author 连杰
 */
public class TomatoCourseAudioWrapper {
	private TomatoCourseAudioWrapper() {
	}

	// 视频信息
	private String id;
	private String name;
	private String subName;
	private String audio;
	private String pic;
	private List<String> introPics;
	private Long createTime;

	private Boolean isFree;

	private String pid;
	// 上次播放时长
	private Integer playLength;

	private Boolean locked;
	private Boolean isAudition;
	private Integer seq; // 集数

	public static TomatoCourseAudioWrapper of(TomatoCourseAudio a, int type) {
		return new TomatoCourseAudioWrapper().setId(a.getId()).setName(a.getName()).setSubName(a.getSubName())
				.setAudio(a.getAudio()).setPic(a.getPic()).setIntroPics(a.getIntroPics())
				.setCreateTime(a.getCreateTime()).setIsFree(type == 0); // 0免费1付费
	}

	public String getId() {
		return id;
	}

	public TomatoCourseAudioWrapper setId(String id) {
		this.id = id;
		return this;
	}

	public String getName() {
		return name;
	}

	public TomatoCourseAudioWrapper setName(String name) {
		this.name = name;
		return this;
	}

	public String getSubName() {
		return subName;
	}

	public TomatoCourseAudioWrapper setSubName(String subName) {
		this.subName = subName;
		return this;
	}

	public String getAudio() {
		return audio;
	}

	public TomatoCourseAudioWrapper setAudio(String audio) {
		this.audio = AliyunBean.getImagesUrl(audio);
		return this;
	}

	public String getPic() {
		return pic;
	}

	public TomatoCourseAudioWrapper setPic(String pic) {
		this.pic = AliyunBean.getImagesUrl(pic);
		return this;
	}

	public Long getCreateTime() {
		return createTime;
	}

	public TomatoCourseAudioWrapper setCreateTime(Long createTime) {
		this.createTime = createTime;
		return this;
	}

	public String getPid() {
		return pid;
	}

	public TomatoCourseAudioWrapper setPid(String pid) {
		this.pid = pid;
		return this;
	}

	public Integer getPlayLength() {
		return playLength;
	}

	public TomatoCourseAudioWrapper setPlayLength(Integer playLength) {
		this.playLength = playLength;
		return this;
	}

	public Boolean getLocked() {
		return locked;
	}

	public TomatoCourseAudioWrapper setLocked(Boolean locked) {
		this.locked = locked;
		return this;
	}

	public Boolean getIsAudition() {
		return isAudition;
	}

	public TomatoCourseAudioWrapper setIsAudition(Boolean isAudition) {
		this.isAudition = isAudition;
		return this;
	}

	public Integer getSeq() {
		return seq;
	}

	public TomatoCourseAudioWrapper setSeq(Integer seq) {
		this.seq = seq;
		return this;
	}

	public List<String> getIntroPics() {
		return introPics;
	}

	public TomatoCourseAudioWrapper setIntroPics(String introPics) {
		this.introPics = Lists.newArrayList();
		if (StringUtils.isNotEmpty(introPics)) {
			for (String wp : StringUtils.split(introPics, ",")) {
				this.introPics.add(AliyunBean.getImagesUrl(wp));
			}
		}
		return this;
	}

	public Boolean getIsFree() {
		return isFree;
	}

	public TomatoCourseAudioWrapper setIsFree(Boolean isFree) {
		this.isFree = isFree;
		return this;
	}

}
