package com.jz.jar.business.request;

import java.util.Collection;

import com.jz.jar.media.enums.BrandEnum;

/**
 * @Title UserRequest
 * @Package com.jz.api.request
 * @author tangjunfeng
 * @date 2019年1月11日 下午3:44:00
 * @version V1.0
 */
public class UserRequest {
	private UserRequest() {
	}

	private BrandEnum brand;
	private String uid;
	private String puid;
	private Collection<String> puids;
	private boolean withChildren = false;

	public static UserRequest of(String puid) {
		return new UserRequest().setPuid(puid);
	}

	public static UserRequest of(String uid, String puid) {
		return of(puid).setUid(uid);
	}

	public static UserRequest of(Collection<String> puids) {
		return new UserRequest().setPuids(puids);
	}

	public static UserRequest of(Collection<String> puids, boolean withChildren) {
		return of(puids).setWithChildren(withChildren);
	}

	public static UserRequest of(String uid, Collection<String> puids, boolean withChildren) {
		return of(puids, withChildren).setUid(uid);
	}

	public BrandEnum getBrand() {
		return brand;
	}

	public UserRequest setBrand(BrandEnum brand) {
		this.brand = brand;
		return this;
	}

	public String getUid() {
		return uid;
	}

	public UserRequest setUid(String uid) {
		this.uid = uid;
		return this;
	}

	public String getPuid() {
		return puid;
	}

	public UserRequest setPuid(String puid) {
		this.puid = puid;
		return this;
	}

	public Collection<String> getPuids() {
		return puids;
	}

	public UserRequest setPuids(Collection<String> puids) {
		this.puids = puids;
		return this;
	}

	public boolean isWithChildren() {
		return withChildren;
	}

	public UserRequest setWithChildren(boolean withChildren) {
		this.withChildren = withChildren;
		return this;
	}

}
