/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.business.proxy;

import com.jz.common.utils.jz.IdTools;
import com.jz.common.utils.text.StringTools;
import com.jz.jar.franchise.service.ParentInfoService;
import com.jz.jooq.franchise.tables.pojos.ParentInfo;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class ParentInfoBusinessProxy {
    @Autowired
    private ParentInfoService parentInfoService;
    private static final int _1Million = 1000000;
    private static final int _100Thousand = 100000;

    public Pair<ParentInfo, Boolean> getOrCreateParentInfo(String phone, String relation, boolean appLogin) {
        ParentInfo parentInfo = this.parentInfoService.getParentInfoForPhone(phone);
        if (null != parentInfo) {
            this.setDefaultUserName(parentInfo);
            return Pair.of((Object)parentInfo, (Object)false);
        }
        int appLoginVal = appLogin ? 1 : 0;
        this.parentInfoService.savePatentInfo(IdTools.encode((String)(phone + System.nanoTime())), phone, relation, appLoginVal);
        parentInfo = this.parentInfoService.getParentInfoForPhone(phone);
        if (null == parentInfo) {
            throw new NullPointerException("register parent info failed");
        }
        this.setDefaultUserName(parentInfo);
        return Pair.of((Object)parentInfo, (Object)true);
    }

    private void setDefaultUserName(ParentInfo parentInfo) {
        if (null == parentInfo) {
            return;
        }
        if (StringTools.isEmptyAndBlank((String)parentInfo.getName())) {
            int code = Math.abs(parentInfo.getPuid().hashCode()) % 1000000;
            if (code < 100000) {
                code += 100000;
            }
            this.parentInfoService.updateUserInfo(parentInfo.getPuid(), "\u7528\u6237" + code, null);
        }
    }
}

