package com.jz.jar.business.wrapper;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.jz.jar.business.enums.TimeStatus;
import com.jz.jar.franchise.wrapper.OnlineLessonWrapper;
import com.jz.jooq.franchise.tables.pojos.Lesson;

/**
 * @Title LessonWrapper
 * @Package com.jz.jar.media.wrapper
 * @author tangjunfeng
 * @date 2018年8月21日 下午5:29:01
 * @version V1.0
 */
public class LessonWrapper extends WPBFeedback {
	private LessonWrapper() {
	}

	private String schoolId;
	private String schoolName;

	// 课程名称
	private String lessonId;
	private String lessonName;
	// 课程的图标
	private String pic;
	// 第几节
	private Integer lessonTimes;
	private String lessonTitle;
	private Long startTime;
	private Long endTime;
	private String courseName;
	// 上课的状态
	private TimeStatus classStatus;
	// 教室
	private String classroom;
	// 学员的上课状态
	private List<TimeStatus> studentClassStatus;
	// 教师
	private TeacherWrapper teacher;
	// 是否已请假
	private Boolean isLeave;
	// 是否已旷课
	private Boolean isTruant;
	// 上课状态
	private Integer status; // 0未上1已上2请假3旷课
	// 合同id
	private String contractId;
	// 当前合同的请假次数
	private Integer currentLeaveNum;
	// 当前合同的请假次数
	private Integer schoolLeaveNum;
	// 剩余的请假次数
	private Integer restLeaveNum;
	// 专辑
	private PlaylistWrapper playlist;
	// 作品ID
	private String worksId;
	// 是否正式课
	private Boolean isFormalLesson;

	// 加入班级的类型（内部使用）
	private Integer lessonStudentType;

	// 在线课程
	private OnlineLessonWrapper onlineLesson;

	// 引导视频id
	private String guideWid;

	public static LessonWrapper of(Lesson lesson) {
		return new LessonWrapper().setSchoolId(lesson.getSchoolId()).setLessonId(lesson.getLessonId())
				.setLessonTimes(lesson.getLessonTime()).setLessonTitle(lesson.getContent())
				.setStartTime(lesson.getStartTime()).setEndTime(lesson.getEndTime())
				.setIsFormalLesson(null != lesson.getCourseId() && lesson.getCourseId() > 0);
	}

	public String getSchoolId() {
		return schoolId;
	}

	public LessonWrapper setSchoolId(String schoolId) {
		this.schoolId = schoolId;
		return this;
	}

	public String getSchoolName() {
		return schoolName;
	}

	public LessonWrapper setSchoolName(String schoolName) {
		this.schoolName = schoolName;
		return this;
	}

	public String getLessonId() {
		return lessonId;
	}

	public LessonWrapper setLessonId(String lessonId) {
		this.lessonId = lessonId;
		return this;
	}

	public String getLessonName() {
		return lessonName;
	}

	public LessonWrapper setLessonName(String lessonName) {
		this.lessonName = lessonName;
		return this;
	}

	public String getPic() {
		return pic;
	}

	public LessonWrapper setPic(String pic) {
		this.pic = pic;
		return this;
	}

	public Integer getLessonTimes() {
		return lessonTimes;
	}

	public LessonWrapper setLessonTimes(Integer lessonTimes) {
		this.lessonTimes = lessonTimes;
		return this;
	}

	public String getLessonTitle() {
		return lessonTitle;
	}

	public LessonWrapper setLessonTitle(String lessonTitle) {
		this.lessonTitle = lessonTitle;
		return this;
	}

	public Long getStartTime() {
		return startTime;
	}

	public LessonWrapper setStartTime(Long startTime) {
		this.startTime = startTime;
		return this;
	}

	public Long getEndTime() {
		return endTime;
	}

	public LessonWrapper setEndTime(Long endTime) {
		this.endTime = endTime;
		return this;
	}

	public String getCourseName() {
		return courseName;
	}

	public LessonWrapper setCourseName(String courseName) {
		this.courseName = courseName;
		return this;
	}

	public TimeStatus getClassStatus() {
		return classStatus;
	}

	public LessonWrapper setClassStatus(TimeStatus classStatus) {
		this.classStatus = classStatus;
		return this;
	}

	public String getClassroom() {
		return classroom;
	}

	public LessonWrapper setClassroom(String classroom) {
		this.classroom = classroom;
		return this;
	}

	public List<TimeStatus> getStudentClassStatus() {
		return studentClassStatus;
	}

	public LessonWrapper setStudentClassStatus(List<TimeStatus> studentClassStatus) {
		this.studentClassStatus = studentClassStatus;
		return this;
	}

	public TeacherWrapper getTeacher() {
		return teacher;
	}

	public LessonWrapper setTeacher(TeacherWrapper teacher) {
		this.teacher = teacher;
		return this;
	}

	public Boolean getIsLeave() {
		return isLeave;
	}

	public LessonWrapper setIsLeave(Boolean isLeave) {
		this.isLeave = isLeave;
		return this;
	}

	public Boolean getIsTruant() {
		return isTruant;
	}

	public LessonWrapper setIsTruant(Boolean isTruant) {
		this.isTruant = isTruant;
		return this;
	}

	public String getContractId() {
		return contractId;
	}

	public LessonWrapper setContractId(String contractId) {
		this.contractId = contractId;
		return this;
	}

	@JsonIgnore
	public Integer getCurrentLeaveNum() {
		return currentLeaveNum;
	}

	public LessonWrapper setCurrentLeaveNum(Integer currentLeaveNum) {
		this.currentLeaveNum = currentLeaveNum;
		return this;
	}

	public Integer getSchoolLeaveNum() {
		return schoolLeaveNum;
	}

	public LessonWrapper setSchoolLeaveNum(Integer schoolLeaveNum) {
		this.schoolLeaveNum = schoolLeaveNum;
		return this;
	}

	public Integer getRestLeaveNum() {
		if (null != restLeaveNum)
			return restLeaveNum;
		if (null != schoolLeaveNum && null != currentLeaveNum) {
			restLeaveNum = schoolLeaveNum - currentLeaveNum;
			return restLeaveNum = restLeaveNum < 0 ? 0 : restLeaveNum;
		}
		if (null != schoolLeaveNum)
			return schoolLeaveNum;
		return restLeaveNum;
	}

	public LessonWrapper setRestLeaveNum(Integer restLeaveNum) {
		return this;
	}

	public PlaylistWrapper getPlaylist() {
		return playlist;
	}

	public LessonWrapper setPlaylist(PlaylistWrapper playlist) {
		this.playlist = playlist;
		return this;
	}

	public String getWorksId() {
		return worksId;
	}

	public LessonWrapper setWorksId(String worksId) {
		this.worksId = worksId;
		return this;
	}

	@JsonIgnore
	public Boolean getIsFormalLesson() {
		return isFormalLesson;
	}

	public LessonWrapper setIsFormalLesson(Boolean isFormalLesson) {
		this.isFormalLesson = isFormalLesson;
		return this;
	}

	public Integer getLessonStudentType() {
		return lessonStudentType;
	}

	public LessonWrapper setLessonStudentType(Integer lessonStudentType) {
		this.lessonStudentType = lessonStudentType;
		return this;
	}

	public OnlineLessonWrapper getOnlineLesson() {
		return onlineLesson;
	}

	public LessonWrapper setOnlineLesson(OnlineLessonWrapper onlineLesson) {
		this.onlineLesson = onlineLesson;
		return this;
	}

	public Integer getStatus() {
		return status;
	}

	public LessonWrapper setStatus(Integer status) {
		this.status = status;
		return this;
	}

	public String getGuideWid() {
		return guideWid;
	}

	public LessonWrapper setGuideWid(String guideWid) {
		this.guideWid = guideWid;
		return this;
	}

}
