package com.jz.jar.business.wrapper;

import com.jz.jar.business.bean.AliyunBean;
import com.jz.jooq.media.tables.pojos.WorksVideo;

public class WorksVideoWrapper {

	private String wid;
	private String fileName; // 文件名
	private String playUrl; // 播放地址
	private Integer duration;// 视频时长
	private String pic;// 封面图地址
	private Integer status;// 0转码中 1已发布 -1已删除

	public static WorksVideoWrapper of() {
		return new WorksVideoWrapper();
	}

	public static WorksVideoWrapper of(WorksVideo v) {
		return new WorksVideoWrapper().setWid(v.getWid()).setFileName(v.getFileName()).setDuration(v.getDuration())
				.setPic(v.getPic()).setStatus(v.getStatus());
	}

	public String getWid() {
		return wid;
	}

	public WorksVideoWrapper setWid(String wid) {
		this.wid = wid;
		return this;
	}

	public String getPlayUrl() {
		return playUrl;
	}

	public WorksVideoWrapper setPlayUrl(String playUrl) {
		this.playUrl = playUrl;
		return this;
	}

	public Integer getDuration() {
		return duration;
	}

	public WorksVideoWrapper setDuration(Integer duration) {
		this.duration = duration;
		return this;
	}

	public String getFileName() {
		return fileName;
	}

	public WorksVideoWrapper setFileName(String fileName) {
		this.fileName = fileName;
		return this;
	}

	public String getPic() {
		return pic;
	}

	public WorksVideoWrapper setPic(String pic) {
		this.pic = AliyunBean.getImagesUrl(pic);
		return this;
	}

	public Integer getStatus() {
		return status;
	}

	public WorksVideoWrapper setStatus(Integer status) {
		this.status = status;
		return this;
	}

}
