package com.jz.jar.business.wrapper;

import java.util.List;

import com.jz.jar.business.bean.AliyunBean;
import com.jz.jooq.media.tables.pojos.AiLesson;

/**
 * @author 连杰
 */
public class AiLessonWrapper {
	private AiLessonWrapper() {
	}

	// 视频信息
	private String aid;
	private String name;
	private String pic;
	private Boolean isFree;
	private String pid;
	private Boolean locked;
	private Boolean isAudition;
	private Long openTime;
	// 学习状态
	private Integer learnStatus;

	private List<AiSectionWrapper> sections;
	private String playSectionId;

	private String myWorksTitle;
	private String allWorksTitle;
	private String appraiseSvg;

	public static AiLessonWrapper of(AiLesson a, int type) {
		return new AiLessonWrapper().setAid(a.getAid()).setName(a.getName()).setPic(a.getPic()).setIsFree(type == 0); // 0免费1付费
	}

	public String getAid() {
		return aid;
	}

	public AiLessonWrapper setAid(String aid) {
		this.aid = aid;
		return this;
	}

	public String getName() {
		return name;
	}

	public AiLessonWrapper setName(String name) {
		this.name = name;
		return this;
	}

	public String getPic() {
		return pic;
	}

	public AiLessonWrapper setPic(String pic) {
		this.pic = AliyunBean.getImagesUrl(pic);
		return this;
	}

	public Boolean getIsFree() {
		return isFree;
	}

	public AiLessonWrapper setIsFree(Boolean isFree) {
		this.isFree = isFree;
		return this;
	}

	public String getPid() {
		return pid;
	}

	public AiLessonWrapper setPid(String pid) {
		this.pid = pid;
		return this;
	}

	public Boolean getLocked() {
		return locked;
	}

	public AiLessonWrapper setLocked(Boolean locked) {
		this.locked = locked;
		return this;
	}

	public Boolean getIsAudition() {
		return isAudition;
	}

	public AiLessonWrapper setIsAudition(Boolean isAudition) {
		this.isAudition = isAudition;
		return this;
	}

	public Long getOpenTime() {
		return openTime;
	}

	public AiLessonWrapper setOpenTime(Long openTime) {
		this.openTime = openTime;
		return this;
	}

	public Integer getLearnStatus() {
		return learnStatus;
	}

	public AiLessonWrapper setLearnStatus(Integer learnStatus) {
		this.learnStatus = learnStatus;
		return this;
	}

	public List<AiSectionWrapper> getSections() {
		return sections;
	}

	public AiLessonWrapper setSections(List<AiSectionWrapper> sections) {
		this.sections = sections;
		return this;
	}

	public String getPlaySectionId() {
		return playSectionId;
	}

	public AiLessonWrapper setPlaySectionId(String playSectionId) {
		this.playSectionId = playSectionId;
		return this;
	}

	public String getMyWorksTitle() {
		return myWorksTitle;
	}

	public AiLessonWrapper setMyWorksTitle(String myWorksTitle) {
		this.myWorksTitle = myWorksTitle;
		return this;
	}

	public String getAllWorksTitle() {
		return allWorksTitle;
	}

	public AiLessonWrapper setAllWorksTitle(String allWorksTitle) {
		this.allWorksTitle = allWorksTitle;
		return this;
	}

	public String getAppraiseSvg() {
		return appraiseSvg;
	}

	public AiLessonWrapper setAppraiseSvg(String appraiseSvg) {
		this.appraiseSvg =AliyunBean.getImagesUrl(appraiseSvg) ;
		return this;
	}

}
