/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.business.proxy.common;

import com.google.common.collect.Lists;
import com.jz.jar.business.wrapper.TitleWrapper;
import com.jz.jar.media.service.UserSignService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Triple;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class PlayTitleProxy {
    private static final List<Triple<Integer, Integer, Integer>> titleConfig = Lists.newArrayList();
    @Autowired
    private UserSignService userSignService;

    public Map<String, Integer> getCountDays(String uid, Collection<String> suidArray) {
        return this.userSignService.getCountDays(uid, suidArray);
    }

    public int getSignCnt(String uid, String suid) {
        return this.userSignService.countDays(uid, suid);
    }

    public Integer getTitle(int signDays) {
        for (Triple<Integer, Integer, Integer> triple : titleConfig) {
            if ((Integer)triple.getLeft() > signDays || signDays > (Integer)triple.getMiddle()) continue;
            return (Integer)triple.getRight();
        }
        return (Integer)titleConfig.get(0).getRight();
    }

    public TitleWrapper getNextTitleDays(int signDays) {
        Triple<Integer, Integer, Integer> triple = null;
        int tempIndex = -1;
        for (int i = 0; i < titleConfig.size(); ++i) {
            triple = titleConfig.get(i);
            if ((Integer)triple.getLeft() > signDays || signDays > (Integer)triple.getMiddle()) continue;
            tempIndex = i + 1;
            break;
        }
        if (tempIndex == -1 || tempIndex >= titleConfig.size()) {
            return null;
        }
        triple = titleConfig.get(tempIndex);
        return TitleWrapper.of((Integer)triple.getLeft() - signDays, (Integer)triple.getRight());
    }

    public List<TitleWrapper> getTitles() {
        ArrayList result = Lists.newArrayList();
        Triple<Integer, Integer, Integer> triple = null;
        for (int i = 1; i < titleConfig.size(); ++i) {
            triple = titleConfig.get(i);
            result.add(TitleWrapper.of((Integer)triple.getLeft(), (Integer)titleConfig.get(i - 1).getRight()));
        }
        triple = titleConfig.get(titleConfig.size() - 1);
        result.add(TitleWrapper.of((Integer)triple.getLeft(), (Integer)triple.getRight()));
        return result;
    }

    static {
        titleConfig.add((Triple<Integer, Integer, Integer>)Triple.of((Object)0, (Object)29, (Object)1));
        titleConfig.add((Triple<Integer, Integer, Integer>)Triple.of((Object)30, (Object)49, (Object)2));
        titleConfig.add((Triple<Integer, Integer, Integer>)Triple.of((Object)50, (Object)99, (Object)3));
        titleConfig.add((Triple<Integer, Integer, Integer>)Triple.of((Object)100, (Object)129, (Object)4));
        titleConfig.add((Triple<Integer, Integer, Integer>)Triple.of((Object)130, (Object)Integer.MAX_VALUE, (Object)5));
    }
}

