package com.jz.jar.business.wrapper;

import com.jz.jar.business.enums.TimeStatus;
import com.jz.jooq.franchise.tables.pojos.ActivityHo;

public class ActivityWrapper {
	private ActivityWrapper() {
	}

	private String activityId;
	private String title;
	private Long startTime;
	private Long endTime;
	private String pic;
	private String displayUrl;

	private TimeStatus status;

	public static ActivityWrapper of(ActivityHo activityInfo) {
		return new ActivityWrapper().setActivityId(activityInfo.getActivityId()).setTitle(activityInfo.getName())
				.setStartTime(activityInfo.getStartTime()).setEndTime(activityInfo.getEndTime())
				.setDisplayUrl(activityInfo.getDisplayUrl());
	}

	public String getActivityId() {
		return activityId;
	}

	public ActivityWrapper setActivityId(String activityId) {
		this.activityId = activityId;
		return this;
	}

	public String getTitle() {
		return title;
	}

	public ActivityWrapper setTitle(String title) {
		this.title = title;
		return this;
	}

	public Long getStartTime() {
		return startTime;
	}

	public ActivityWrapper setStartTime(Long startTime) {
		this.startTime = startTime;
		return this;
	}

	public Long getEndTime() {
		return endTime;
	}

	public ActivityWrapper setEndTime(Long endTime) {
		this.endTime = endTime;
		return this;
	}

	public String getPic() {
		return pic;
	}

	public ActivityWrapper setPic(String pic) {
		this.pic = pic;
		return this;
	}

	public String getDisplayUrl() {
		return displayUrl;
	}

	public ActivityWrapper setDisplayUrl(String displayUrl) {
		this.displayUrl = displayUrl;
		return this;
	}

	public TimeStatus getStatus() {
		return status;
	}

	public ActivityWrapper setStatus(TimeStatus status) {
		this.status = status;
		return this;
	}

}
