package com.jz.jar.business.wrapper;

import java.util.Collection;
import java.util.List;

import org.apache.commons.lang3.StringUtils;

import com.alibaba.fastjson.JSON;
import com.aliyun.opensearch.sdk.dependencies.com.google.common.collect.Lists;
import com.jz.jar.business.bean.AliyunBean;
import com.jz.jooq.media.tables.pojos.TomatoCourseWorks;

public class TomatoCourseWorksWrapper {
	private TomatoCourseWorksWrapper() {
	}

	private String id;
	private List<String> pics; // 图片集
	private String appraise; // 评价
	private String honourPic; // 荣誉图片
	private Long createTime;
	private Long appraiseTime;

	private Collection<WLessonReport> lessonReports;

	public static TomatoCourseWorksWrapper of(TomatoCourseWorks w) {
		return new TomatoCourseWorksWrapper().setId(w.getId()).setPics(w.getPics()).setAppraise(w.getAppraise())
				.setHonourPic(w.getHonourPic()).setCreateTime(w.getCreateTime()).setAppraiseTime(w.getAppraiseTime());
	}

	public String getId() {
		return id;
	}

	public TomatoCourseWorksWrapper setId(String id) {
		this.id = id;
		return this;
	}

	public List<String> getPics() {
		return pics;
	}

	public TomatoCourseWorksWrapper setPics(String pics) {
		this.pics = Lists.newArrayList();
		if (StringUtils.isNotEmpty(pics)) {
			for (String p : JSON.parseArray(pics, String.class)) {
				this.pics.add(AliyunBean.getImagesUrl(p));
			}
		}
		return this;
	}

	public String getAppraise() {
		return appraise;
	}

	public TomatoCourseWorksWrapper setAppraise(String appraise) {
		this.appraise = appraise;
		return this;
	}

	public Long getCreateTime() {
		return createTime;
	}

	public TomatoCourseWorksWrapper setCreateTime(Long createTime) {
		this.createTime = createTime;
		return this;
	}

	public Long getAppraiseTime() {
		return appraiseTime;
	}

	public TomatoCourseWorksWrapper setAppraiseTime(Long appraiseTime) {
		this.appraiseTime = appraiseTime;
		return this;
	}

	public Collection<WLessonReport> getLessonReports() {
		return lessonReports;
	}

	public TomatoCourseWorksWrapper setLessonReports(Collection<WLessonReport> lessonReports) {
		this.lessonReports = lessonReports;
		return this;
	}

	public String getHonourPic() {
		return honourPic;
	}

	public TomatoCourseWorksWrapper setHonourPic(String honourPic) {
		this.honourPic = AliyunBean.getImagesUrl(honourPic);
		return this;
	}

}
