package com.jz.jar.business.wrapper;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * @author 连杰
 */
public class AiPackHomeWrapper {
	private AiPackHomeWrapper() {
	}

	private String pid;
	private String packName;
	private Integer status; // 1即将开始 2立即学习
	private String playAid; // 点击立即学习要跳转的aid
	private String lessonName; // 显示的课程名字
	private String startTimeStr;// 上课时间
	private Long startTime;// 上课时间

	public static AiPackHomeWrapper of(String pid) {
		return new AiPackHomeWrapper().setPid(pid);
	}

	public String getPid() {
		return pid;
	}

	public AiPackHomeWrapper setPid(String pid) {
		this.pid = pid;
		return this;
	}

	public String getPackName() {
		return packName;
	}

	public AiPackHomeWrapper setPackName(String packName) {
		this.packName = packName;
		return this;
	}

	public Integer getStatus() {
		return status;
	}

	public AiPackHomeWrapper setStatus(Integer status) {
		this.status = status;
		return this;
	}

	public String getLessonName() {
		return lessonName;
	}

	public AiPackHomeWrapper setLessonName(String lessonName) {
		this.lessonName = lessonName;
		return this;
	}

	public String getPlayAid() {
		return playAid;
	}

	public AiPackHomeWrapper setPlayAid(String playAid) {
		this.playAid = playAid;
		return this;
	}

	public String getStartTimeStr() {
		return startTimeStr;
	}

	public AiPackHomeWrapper setStartTime(Long startTime) {
		this.startTime = startTime;
		return this;
	}

	public Long getStartTime() {
		return startTime;
	}

	public AiPackHomeWrapper setNeedDealStartTime(Long startTime, String prefix) {
		if (startTime != null) {
			this.startTime = startTime + 18 * 3600 * 1000l;
			if (prefix != null) {
				DateFormat df = new SimpleDateFormat("yyyy年MM月dd日 HH:mm");
				this.startTimeStr = prefix + ":" + df.format(new Date(this.startTime));
			}
		}
		return this;
	}

}
