/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.business.proxy;

import com.google.common.collect.Lists;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.i18n.cn.PinyinTool;
import com.jz.common.utils.jz.IdTools;
import com.jz.common.utils.text.StringTools;
import com.jz.jar.business.proxy.ParentInfoBusinessProxy;
import com.jz.jar.business.request.ReservationRequest;
import com.jz.jar.business.response.ReservationResponse;
import com.jz.jar.franchise.service.ContractService;
import com.jz.jar.franchise.service.MarketCasePoolService;
import com.jz.jar.franchise.service.ParentInfoService;
import com.jz.jar.franchise.service.SchoolService;
import com.jz.jar.franchise.service.StudentInfoService;
import com.jz.jar.franchise.wrapper.CaseChildWrapper;
import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.service.ReservationService;
import com.jz.jar.media.service.UserCoinTaskService;
import com.jz.jooq.franchise.tables.pojos.MarketCasePool;
import com.jz.jooq.franchise.tables.pojos.ParentInfo;
import com.jz.jooq.franchise.tables.pojos.School;
import com.jz.jooq.franchise.tables.pojos.StudentInfo;
import com.jz.jooq.media.tables.records.ReservationRecord;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class ReservationBusinessProxy {
    @Autowired
    private SchoolService schoolService;
    @Autowired
    private ParentInfoService parentInfoService;
    @Autowired
    private ReservationService reservationService;
    @Autowired
    private MarketCasePoolService marketCasePoolService;
    @Autowired
    private StudentInfoService studentInfoService;
    @Autowired
    private ParentInfoBusinessProxy parentInfoBusinessProxy;
    @Autowired
    private UserCoinTaskService userCoinTaskService;
    @Autowired
    private ContractService contractService;

    public ReservationResponse apply(ReservationRequest request, String channelId) {
        MarketCasePool mcp;
        School school = this.schoolService.getSchool(request.getSchoolId());
        if (null == school || school.getCode() < 100 || !school.getBrandId().equals(request.getBrand().name())) {
            return ReservationResponse.failed("\u65e0\u6548\u7684\u4e2d\u5fc3");
        }
        ParentInfo parentInfo = null;
        if (StringTools.isNotEmptyAndBlank((String)request.getUid())) {
            parentInfo = this.parentInfoService.getParentInfoForId(request.getUid());
        } else if (StringTools.isNotEmptyAndBlank((String)request.getPhone())) {
            Pair<ParentInfo, Boolean> pair = this.parentInfoBusinessProxy.getOrCreateParentInfo(request.getPhone(), request.getRelation(), false);
            parentInfo = (ParentInfo)pair.getLeft();
        }
        if (null == parentInfo) {
            return ReservationResponse.failed("\u65e0\u6548\u7684\u7528\u6237");
        }
        if (StringUtils.isEmpty((CharSequence)parentInfo.getRelation()) && StringUtils.isNotEmpty((CharSequence)request.getRelation())) {
            this.parentInfoService.updateRelation(parentInfo.getPuid(), request.getRelation());
            parentInfo.setRelation(request.getRelation());
        }
        if (!this.reservationService.existValidReservation(parentInfo.getPuid(), school.getId())) {
            this.saveReservation(request.getBrand(), parentInfo, school);
        }
        if ((mcp = this.marketCasePoolService.getMarketCaseByPhone(school.getId(), parentInfo.getPhone())) == null) {
            this.createMarketCase(request, school, parentInfo, channelId);
        } else {
            this.marketCasePoolService.joinAuditionForOldCase(mcp, channelId);
        }
        if (!this.contractService.isHaveContract(school.getBrandId(), parentInfo.getPuid())) {
            this.userCoinTaskService.dealTask(parentInfo.getPuid(), school.getBrandId(), "audition");
        }
        return ReservationResponse.ok();
    }

    private String createMarketCase(ReservationRequest request, School school, ParentInfo parentInfo, String channelId) {
        ArrayList childs;
        block6: {
            List sis;
            block4: {
                block5: {
                    childs = Lists.newArrayList();
                    sis = null;
                    if (null == request.getSuid()) {
                        sis = this.studentInfoService.getStudents(parentInfo.getPuid());
                    }
                    if (!request.getIsExistStudent().booleanValue()) break block4;
                    if (null == request.getSuid()) break block5;
                    childs.add(CaseChildWrapper.of((StudentInfo)this.studentInfoService.getStudent(request.getSuid())));
                    break block6;
                }
                childs.add(CaseChildWrapper.of((String)request.getName(), (String)request.getSex(), (String)request.getBirthday()));
                if (this.searchStudent(sis, request)) break block6;
                Pair py = PinyinTool.getPinyinAndHeadChar((String)request.getName());
                this.studentInfoService.refreshStudent(parentInfo.getPuid(), IdTools.encode((String)parentInfo.getPuid()), request.getName(), null, request.getSex(), request.getBirthday(), null, (String)py.getLeft(), (String)py.getRight());
                break block6;
            }
            if (ArrayMapTools.isNotEmpty((Collection)sis)) {
                for (StudentInfo si : sis) {
                    childs.add(CaseChildWrapper.of((StudentInfo)si));
                }
            }
        }
        String caseId = IdTools.encode((String)parentInfo.getPuid());
        StringBuffer py = new StringBuffer();
        if (ArrayMapTools.isNotEmpty((Collection)childs)) {
            childs.forEach(c -> {
                if (StringTools.isEmptyAndBlank((String)c.getName())) {
                    return;
                }
                Pair tp = PinyinTool.getPinyinAndHeadChar((String)c.getName());
                py.append((String)tp.getLeft()).append(",").append((String)tp.getRight()).append(",");
            });
        }
        this.marketCasePoolService.createCase(caseId, "system", school.getId(), channelId, parentInfo.getPhone(), "", "", (List)childs, py.toString(), parentInfo.getName(), parentInfo.getRelation(), parentInfo.getAddress(), parentInfo.getDistrict(), "A", 0L);
        return caseId;
    }

    private void saveReservation(BrandEnum brand, ParentInfo parentInfo, School school) {
        ReservationRecord record = new ReservationRecord();
        record.setBrand(brand.name());
        record.setUid(parentInfo.getPuid());
        record.setPhone(parentInfo.getPhone());
        record.setName(parentInfo.getName());
        record.setSchoolId(school.getId());
        record.setStatus(Integer.valueOf(1));
        record.setCreateTime(Long.valueOf(System.currentTimeMillis()));
        this.reservationService.saveRecord(record);
    }

    private boolean searchStudent(List<StudentInfo> studentInfos, ReservationRequest request) {
        if (ArrayMapTools.isEmpty(studentInfos) || !request.getIsExistStudent().booleanValue()) {
            return false;
        }
        if (StringTools.isEmpty((CharSequence)request.getName()) || StringTools.isEmpty((CharSequence)request.getSex())) {
            return false;
        }
        for (StudentInfo si : studentInfos) {
            if (StringTools.allEmpty((String[])new String[]{si.getName(), si.getEngName()}) || !StringTools.contains((String[])new String[]{request.getName(), si.getName(), si.getEngName()}) || !si.getSex().equals(request.getSex())) continue;
            return true;
        }
        return false;
    }
}

