package com.jz.jar.business.request;

import java.util.Collection;

public class WorksRequest {
	private WorksRequest() {
	}

	private String workId;
	private Collection<String> worksId;
	private String uid;

	private Boolean withStudent = false;
	private Boolean withExtended = false;
	private Boolean withAuthorUser = false;
	private Boolean withCreateInteractPics = false;

	public static WorksRequest of(String uid, String workId) {
		return new WorksRequest().setWorkId(workId).setUid(uid);
	}

	public static WorksRequest of(Collection<String> worksId) {
		return new WorksRequest().setWorksId(worksId);
	}

	public static WorksRequest of(String uid, Collection<String> worksId) {
		return of(worksId).setUid(uid);
	}

	public String getWorkId() {
		return workId;
	}

	public WorksRequest setWorkId(String workId) {
		this.workId = workId;
		return this;
	}

	public Collection<String> getWorksId() {
		return worksId;
	}

	public WorksRequest setWorksId(Collection<String> worksId) {
		this.worksId = worksId;
		return this;
	}

	public String getUid() {
		return uid;
	}

	public WorksRequest setUid(String uid) {
		this.uid = uid;
		return this;
	}

	public Boolean getWithStudent() {
		return withStudent;
	}

	public WorksRequest setWithStudent(Boolean withStudent) {
		this.withStudent = withStudent;
		return this;
	}

	public Boolean getWithExtended() {
		return withExtended;
	}

	public WorksRequest setWithExtended(Boolean withExtended) {
		this.withExtended = withExtended;
		return this;
	}

	public Boolean getWithAuthorUser() {
		return withAuthorUser;
	}

	public WorksRequest setWithAuthorUser(Boolean withAuthorUser) {
		this.withAuthorUser = withAuthorUser;
		return this;
	}

	public Boolean getWithCreateInteractPics() {
		return withCreateInteractPics;
	}

	public WorksRequest setWithCreateInteractPics(Boolean withCreateInteractPics) {
		this.withCreateInteractPics = withCreateInteractPics;
		return this;
	}

}
