package com.jz.jar.business.proxy.common;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.tuple.Triple;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.jz.jar.business.wrapper.TitleWrapper;
import com.jz.jar.media.service.UserSignService;

@Lazy
@Service
public class PlayTitleProxy {

	private static final List<Triple<Integer, Integer, Integer>> titleConfig = Lists.newArrayList();

	@Autowired
	private UserSignService userSignService;

	static {
		titleConfig.add(Triple.of(0, 29, 1));
		titleConfig.add(Triple.of(30, 49, 2));
		titleConfig.add(Triple.of(50, 99, 3));
		titleConfig.add(Triple.of(100, 129, 4));
		titleConfig.add(Triple.of(130, Integer.MAX_VALUE, 5));
	}
	
	public Map<String, Integer> getCountDays(String uid, Collection<String> suidArray) {
		return userSignService.getCountDays(uid, suidArray);
	}
	
	public int getSignCnt(String uid, String suid) {
		return userSignService.countDays(uid, suid);
	}
	
	/** 获取用户称号 */
	public Integer getTitle(int signDays) {
		for (Triple<Integer, Integer, Integer> triple : titleConfig) {
			if (triple.getLeft() <= signDays && signDays <= triple.getMiddle()) {
				return triple.getRight();
			}
		}
		return titleConfig.get(0).getRight();
	}
	
	/** 获取下一个称号还需要多少天 */
	public TitleWrapper getNextTitleDays(int signDays) {
		Triple<Integer, Integer, Integer> triple = null;
		int tempIndex = -1;
		for (int i = 0; i < titleConfig.size(); i++) {
			triple = titleConfig.get(i);
			if (triple.getLeft() <= signDays && signDays <= triple.getMiddle()) {
				tempIndex = i + 1; // 下一个称号
				break;
			}
		}
		// 未匹配到 || 最后一个
		if (tempIndex == -1 || tempIndex >= titleConfig.size())
			return null;
		triple = titleConfig.get(tempIndex);
		return TitleWrapper.of(triple.getLeft() - signDays, triple.getRight());
	}
	
	public List<TitleWrapper> getTitles() {
		List<TitleWrapper> result = Lists.newArrayList();
		Triple<Integer, Integer, Integer> triple = null;
		for (int i = 1; i < titleConfig.size(); i++) {
			triple = titleConfig.get(i);
			result.add(TitleWrapper.of(triple.getLeft(), titleConfig.get(i - 1).getRight()));
		}
		// 获取最后一个
		triple = titleConfig.get(titleConfig.size() - 1);
		result.add(TitleWrapper.of(triple.getLeft(), triple.getRight()));
		return result;
	}
	
}
