package com.jz.jar.business.card;

import java.util.List;

import com.jz.jar.business.enums.CardType;
import com.jz.jar.business.wrapper.ActivityWrapper;
import com.jz.jar.business.wrapper.AiPackHomeWrapper;
import com.jz.jar.business.wrapper.CommentWrapper;
import com.jz.jar.business.wrapper.HomeThemeWrapper;
import com.jz.jar.business.wrapper.LessonFeedbackWrapper;
import com.jz.jar.business.wrapper.LessonWrapper;
import com.jz.jar.business.wrapper.LevelWrapper;
import com.jz.jar.business.wrapper.NewsInfoWrapper;
import com.jz.jar.business.wrapper.NoticeWrapper;
import com.jz.jar.business.wrapper.OxTabWrapper;
import com.jz.jar.business.wrapper.PlaylistWrapper;
import com.jz.jar.business.wrapper.RecomStudentWrapper;
import com.jz.jar.business.wrapper.TagWrapper;
import com.jz.jar.business.wrapper.TeacherWrapper;
import com.jz.jar.business.wrapper.TomatoCoursePackWrapper;
import com.jz.jar.business.wrapper.TomatoCourseVideoWrapper;
import com.jz.jar.business.wrapper.TopicWrapper;
import com.jz.jar.business.wrapper.VideoWrapper;
import com.jz.jar.business.wrapper.WBannerCard;
import com.jz.jar.business.wrapper.WHomeCard;
import com.jz.jar.business.wrapper.WImageText;
import com.jz.jar.business.wrapper.WWorkTopicTheme;
import com.jz.jar.business.wrapper.WWorkTopicWrapper;
import com.jz.jar.business.wrapper.WorksInfoWrapper;
import com.jz.jar.franchise.wrapper.OnlineLessonWrapper;

/**
 * @Title ItemCard
 * @Package com.jz.jar.media.common
 * @author tangjunfeng
 * @date 2018年8月3日 下午6:35:46
 * @version V1.0
 */
public class ItemCard {
	private ItemCard() {
	}

	private ItemCard(CardType type) {
		this.type = type;
	}

	private CardType type;

	private VideoWrapper video;
	private PlaylistWrapper playlist;
	private LevelWrapper level;
	private TopicWrapper topic;
	private NoticeWrapper notice;
	private LessonWrapper lesson;
	private LessonFeedbackWrapper lessonFb;
	private CommentWrapper comment;
	private WorksInfoWrapper works;
	private List<WorksInfoWrapper> worksList;
	private WWorkTopicTheme theme; // 废弃
	private WWorkTopicWrapper worksTopic;// 作品专题
	private NewsInfoWrapper news;
	private ActivityWrapper activity;
	private TagWrapper tag;
	private OxTabWrapper oxTab;
	private HomeThemeWrapper homeTheme;
	private WImageText imgTxt;
	private WHomeCard homeCard;
	private OnlineLessonWrapper onlineLesson;
	private String content;
	private TomatoCoursePackWrapper coursePack;
	private TomatoCourseVideoWrapper courseVideo;
	private AiPackHomeWrapper ai;
	private RecomStudentWrapper recomStudent;// 蕃茄之星

	private String title; // 蕃茄田首页模块的其中一个标题
	private String subTitle; // 蕃茄田首页模块的其中一个副标题
	private String pic; // 蕃茄田首页模块的其中一个图片
	private String url; // h5卡片地址
	private String tip1; // 推荐要点1
	private String tip2; // 推荐要点2
	private String nickName; // 昵称
	private Number endTime; // 倒计时结束时间

	private List<RecomStudentWrapper> stars;// 蕃茄之星
	private List<WWorkTopicWrapper> topics;// 精选专题
	private WBannerCard banner;// 艺术馆作品列表banner

	private Long startTime;// 课程开始时间
	private TeacherWrapper teacher;// 课老师

	public static ItemCard of() {
		return new ItemCard();
	}

	public static ItemCard of(WBannerCard banner) {
		return new ItemCard(CardType.banner).setBanner(banner);
	}

	public static ItemCard of(VideoWrapper video) {
		return new ItemCard(CardType.video).setVideo(video);
	}

	public static ItemCard of(PlaylistWrapper playlist) {
		return new ItemCard(CardType.playlist).setPlaylist(playlist);
	}

	public static ItemCard of(LevelWrapper level) {
		return new ItemCard(CardType.level).setLevel(level);
	}

	public static ItemCard of(TopicWrapper topic) {
		return new ItemCard(CardType.topic).setTopic(topic);
	}

	public static ItemCard of(NoticeWrapper notice) {
		return new ItemCard(CardType.notice).setNotice(notice);
	}

	public static ItemCard ofSysNotify(NoticeWrapper notice) {
		return new ItemCard(CardType.sysNotify).setNotice(notice);
	}

	public static ItemCard of(LessonWrapper lesson) {
		return new ItemCard(CardType.lesson).setLesson(lesson);
	}

	public static ItemCard of(LessonFeedbackWrapper lessonFb) {
		return new ItemCard(CardType.lessonFb).setLessonFb(lessonFb);
	}

	public static ItemCard of(CommentWrapper comment) {
		return new ItemCard(CardType.comment).setComment(comment);
	}

	public static ItemCard of(WorksInfoWrapper works) {
		return new ItemCard(CardType.works).setWorks(works);
	}

	public static ItemCard of(List<WorksInfoWrapper> worksList) {
		return new ItemCard(CardType.worksList).setWorksList(worksList);
	}

	public static ItemCard of(WWorkTopicTheme theme) {
		return new ItemCard(CardType.theme).setTheme(theme);
	}

	public static ItemCard of(WWorkTopicWrapper t) {
		return new ItemCard(CardType.worksTopic).setWorksTopic(t);
	}

	public static ItemCard of(RecomStudentWrapper rs) {
		return new ItemCard(CardType.star).setRecomStudent(rs);
	}

	public static ItemCard of(NewsInfoWrapper news) {
		return new ItemCard(CardType.news).setNews(news);
	}

	public static ItemCard of(ActivityWrapper activity) {
		return new ItemCard(CardType.activity).setActivity(activity);
	}

	public static ItemCard of(TagWrapper tag) {
		return new ItemCard(CardType.tag).setTag(tag);
	}

	public static ItemCard of(OxTabWrapper oxTab) {
		return new ItemCard(CardType.oxTab).setOxTab(oxTab);
	}

	public static ItemCard of(HomeThemeWrapper homeTheme) {
		return new ItemCard(CardType.home_theme).setHomeTheme(homeTheme);
	}

	public static ItemCard of(WImageText imgTxt) {
		return new ItemCard(CardType.img_txt).setImgTxt(imgTxt);
	}

	public static ItemCard of(WHomeCard homeCard) {
		return new ItemCard(CardType.home_card).setHomeCard(homeCard);
	}

	public static ItemCard of(OnlineLessonWrapper onlineLesson) {
		return new ItemCard(CardType.onlineLesson).setOnlineLesson(onlineLesson);
	}

	public static ItemCard of(CardType type, String content) {
		return new ItemCard(type).setContent(content);
	}

	public static ItemCard of(CardType type) {
		return new ItemCard(type);
	}

	public static ItemCard of(TomatoCoursePackWrapper coursePack) {
		return new ItemCard(CardType.coursePack).setCoursePack(coursePack);
	}

	public static ItemCard of(TomatoCourseVideoWrapper courseVideo) {
		return new ItemCard(CardType.courseVideo).setCourseVideo(courseVideo);
	}

	public static ItemCard of(AiPackHomeWrapper ai) {
		return new ItemCard(CardType.ai).setAi(ai);
	}

	public CardType getType() {
		return type;
	}

	public ItemCard setType(CardType type) {
		this.type = type;
		return this;
	}

	public VideoWrapper getVideo() {
		return video;
	}

	public ItemCard setVideo(VideoWrapper video) {
		this.video = video;
		return this;
	}

	public PlaylistWrapper getPlaylist() {
		return playlist;
	}

	public ItemCard setPlaylist(PlaylistWrapper playlist) {
		this.playlist = playlist;
		return this;
	}

	public LevelWrapper getLevel() {
		return level;
	}

	public ItemCard setLevel(LevelWrapper level) {
		this.level = level;
		return this;
	}

	public TopicWrapper getTopic() {
		return topic;
	}

	public ItemCard setTopic(TopicWrapper topic) {
		this.topic = topic;
		return this;
	}

	public NoticeWrapper getNotice() {
		return notice;
	}

	public ItemCard setNotice(NoticeWrapper notice) {
		this.notice = notice;
		return this;
	}

	public LessonWrapper getLesson() {
		return lesson;
	}

	public ItemCard setLesson(LessonWrapper lesson) {
		this.lesson = lesson;
		return this;
	}

	public LessonFeedbackWrapper getLessonFb() {
		return lessonFb;
	}

	public ItemCard setLessonFb(LessonFeedbackWrapper lessonFb) {
		this.lessonFb = lessonFb;
		return this;
	}

	public CommentWrapper getComment() {
		return comment;
	}

	public ItemCard setComment(CommentWrapper comment) {
		this.comment = comment;
		return this;
	}

	public WorksInfoWrapper getWorks() {
		return works;
	}

	public ItemCard setWorks(WorksInfoWrapper works) {
		this.works = works;
		return this;
	}

	public List<WorksInfoWrapper> getWorksList() {
		return worksList;
	}

	public ItemCard setWorksList(List<WorksInfoWrapper> worksList) {
		this.worksList = worksList;
		return this;
	}

	public WWorkTopicTheme getTheme() {
		return theme;
	}

	public ItemCard setTheme(WWorkTopicTheme theme) {
		this.theme = theme;
		return this;
	}

	public NewsInfoWrapper getNews() {
		return news;
	}

	public ItemCard setNews(NewsInfoWrapper news) {
		this.news = news;
		return this;
	}

	public ActivityWrapper getActivity() {
		return activity;
	}

	public ItemCard setActivity(ActivityWrapper activity) {
		this.activity = activity;
		return this;
	}

	public TagWrapper getTag() {
		return tag;
	}

	public ItemCard setTag(TagWrapper tag) {
		this.tag = tag;
		return this;
	}

	public OxTabWrapper getOxTab() {
		return oxTab;
	}

	public ItemCard setOxTab(OxTabWrapper oxTab) {
		this.oxTab = oxTab;
		return this;
	}

	public HomeThemeWrapper getHomeTheme() {
		return homeTheme;
	}

	public ItemCard setHomeTheme(HomeThemeWrapper homeTheme) {
		this.homeTheme = homeTheme;
		return this;
	}

	public WImageText getImgTxt() {
		return imgTxt;
	}

	public ItemCard setImgTxt(WImageText imgTxt) {
		this.imgTxt = imgTxt;
		return this;
	}

	public WHomeCard getHomeCard() {
		return homeCard;
	}

	public ItemCard setHomeCard(WHomeCard homeCard) {
		this.homeCard = homeCard;
		return this;
	}

	public OnlineLessonWrapper getOnlineLesson() {
		return onlineLesson;
	}

	public ItemCard setOnlineLesson(OnlineLessonWrapper onlineLesson) {
		this.onlineLesson = onlineLesson;
		return this;
	}

	public String getContent() {
		return content;
	}

	public ItemCard setContent(String content) {
		this.content = content;
		return this;
	}

	public String getTitle() {
		return title;
	}

	public ItemCard setTitle(String title) {
		this.title = title;
		return this;
	}

	public String getSubTitle() {
		return subTitle;
	}

	public ItemCard setSubTitle(String subTitle) {
		this.subTitle = subTitle;
		return this;
	}

	public String getPic() {
		return pic;
	}

	public ItemCard setPic(String pic) {
		this.pic = pic;
		return this;
	}

	public String getUrl() {
		return url;
	}

	public ItemCard setUrl(String url) {
		this.url = url;
		return this;
	}

	public TomatoCoursePackWrapper getCoursePack() {
		return coursePack;
	}

	public ItemCard setCoursePack(TomatoCoursePackWrapper coursePack) {
		this.coursePack = coursePack;
		return this;
	}

	public TomatoCourseVideoWrapper getCourseVideo() {
		return courseVideo;
	}

	public ItemCard setCourseVideo(TomatoCourseVideoWrapper courseVideo) {
		this.courseVideo = courseVideo;
		return this;
	}

	public String getTip1() {
		return tip1;
	}

	public ItemCard setTip1(String tip1) {
		this.tip1 = tip1;
		return this;
	}

	public String getTip2() {
		return tip2;
	}

	public ItemCard setTip2(String tip2) {
		this.tip2 = tip2;
		return this;
	}

	public AiPackHomeWrapper getAi() {
		return ai;
	}

	public ItemCard setAi(AiPackHomeWrapper ai) {
		this.ai = ai;
		return this;
	}

	public String getNickName() {
		return nickName;
	}

	public ItemCard setNickName(String nickName) {
		this.nickName = nickName;
		return this;
	}

	public Number getEndTime() {
		return endTime;
	}

	public ItemCard setEndTime(Number endTime) {
		this.endTime = endTime;
		return this;
	}

	public WWorkTopicWrapper getWorksTopic() {
		return worksTopic;
	}

	public ItemCard setWorksTopic(WWorkTopicWrapper worksTopic) {
		this.worksTopic = worksTopic;
		return this;
	}

	public RecomStudentWrapper getRecomStudent() {
		return recomStudent;
	}

	public ItemCard setRecomStudent(RecomStudentWrapper recomStudent) {
		this.recomStudent = recomStudent;
		return this;
	}

	public List<RecomStudentWrapper> getStars() {
		return stars;
	}

	public ItemCard setStars(List<RecomStudentWrapper> stars) {
		this.stars = stars;
		return this;
	}

	public List<WWorkTopicWrapper> getTopics() {
		return topics;
	}

	public ItemCard setTopics(List<WWorkTopicWrapper> topics) {
		this.topics = topics;
		return this;
	}

	public WBannerCard getBanner() {
		return banner;
	}

	public ItemCard setBanner(WBannerCard banner) {
		this.banner = banner;
		return this;
	}

	public Long getStartTime() {
		return startTime;
	}

	public ItemCard setStartTime(Long startTime) {
		this.startTime = startTime;
		return this;
	}

	public TeacherWrapper getTeacher() {
		return teacher;
	}

	public ItemCard setTeacher(TeacherWrapper teacher) {
		this.teacher = teacher;
		return this;
	}

}
