package com.jz.jar.business.wrapper;

import java.util.List;

import com.google.common.collect.Lists;
import com.jz.jooq.franchise.tables.pojos.Appraise;

/**
 * @Title WLessonReport
 * @Package com.jz.api.wrapper
 * @author tangjunfeng
 * @date 2019年12月27日 下午2:27:49
 * @version V1.0
 */
public class WLessonReport {

	private String name;
	private Integer star;
	private List<LReport> reports;

	public static WLessonReport of(String name, int star) {
		return new WLessonReport().setName(name).setStar(star);
	}

	public String getName() {
		return name;
	}

	public WLessonReport setName(String name) {
		this.name = name;
		return this;
	}

	public Integer getStar() {
		return star;
	}

	public WLessonReport setStar(Integer star) {
		this.star = star;
		return this;
	}

	public List<LReport> getReports() {
		return reports;
	}

	public WLessonReport setReports(List<LReport> reports) {
		this.reports = reports;
		return this;
	}

	public WLessonReport addReport(Appraise appraise) {
		if (this.reports == null)
			this.reports = Lists.newArrayList();
		this.reports.add(new LReport(appraise));
		return this;
	}

	public WLessonReport addReport(String dimension, String ctx) {
		if (this.reports == null)
			this.reports = Lists.newArrayList();
		this.reports.add(new LReport(dimension, ctx));
		return this;
	}

	public class LReport {
		private String dimension;
		private String ctx;

		public LReport(Appraise appraise) {
			this.setDimension(appraise.getDimension()).setCtx(appraise.getCtx());
		}

		public LReport(String dimension, String ctx) {
			this.setDimension(dimension).setCtx(ctx);
		}

		public String getDimension() {
			return dimension;
		}

		public LReport setDimension(String dimension) {
			this.dimension = dimension;
			return this;
		}

		public String getCtx() {
			return ctx;
		}

		public LReport setCtx(String ctx) {
			this.ctx = ctx;
			return this;
		}

	}
}
