package com.jz.jar.business.wrapper;

import com.jz.jooq.media.tables.pojos.MediaBanner;

public class WBannerCard {

	private String id;
	private String brand;
	private String type;
	private String source;
	private String pic;
	private Double ratio;
	private String title;
	private String desc;
	private Integer status;
	private Integer seq;
	private Long createTime;
	private String operater;
	private String showPage;
	private String minAppVersion;
	private Integer popUp;
	private Integer packType;
	private Integer mini;

	private Integer displayType;

	public static WBannerCard of(MediaBanner banner) {
		return new WBannerCard().setId(banner.getId()).setType(banner.getType()).setSource(banner.getSource())
				.setPic(banner.getPic()).setRatio(banner.getRatio()).setTitle(banner.getTitle())
				.setDesc(banner.getDesc()).setPopUp(banner.getPopUp()).setPackType(banner.getPackType())
				.setMini(banner.getMini());
	}

	public String getId() {
		return id;
	}

	public WBannerCard setId(String id) {
		this.id = id;
		return this;
	}

	public String getBrand() {
		return brand;
	}

	public WBannerCard setBrand(String brand) {
		this.brand = brand;
		return this;
	}

	public String getType() {
		return type;
	}

	public WBannerCard setType(String type) {
		this.type = type;
		return this;
	}

	public String getSource() {
		return source;
	}

	public WBannerCard setSource(String source) {
		this.source = source;
		return this;
	}

	public String getPic() {
		return pic;
	}

	public WBannerCard setPic(String pic) {
		this.pic = pic;
		return this;
	}

	public Double getRatio() {
		return ratio;
	}

	public WBannerCard setRatio(Double ratio) {
		this.ratio = ratio;
		return this;
	}

	public String getTitle() {
		return title;
	}

	public WBannerCard setTitle(String title) {
		this.title = title;
		return this;
	}

	public String getDesc() {
		return desc;
	}

	public WBannerCard setDesc(String desc) {
		this.desc = desc;
		return this;
	}

	public Integer getStatus() {
		return status;
	}

	public WBannerCard setStatus(Integer status) {
		this.status = status;
		return this;
	}

	public Integer getSeq() {
		return seq;
	}

	public WBannerCard setSeq(Integer seq) {
		this.seq = seq;
		return this;
	}

	public Long getCreateTime() {
		return createTime;
	}

	public WBannerCard setCreateTime(Long createTime) {
		this.createTime = createTime;
		return this;
	}

	public String getOperater() {
		return operater;
	}

	public WBannerCard setOperater(String operater) {
		this.operater = operater;
		return this;
	}

	public String getShowPage() {
		return showPage;
	}

	public WBannerCard setShowPage(String showPage) {
		this.showPage = showPage;
		return this;
	}

	public String getMinAppVersion() {
		return minAppVersion;
	}

	public WBannerCard setMinAppVersion(String minAppVersion) {
		this.minAppVersion = minAppVersion;
		return this;
	}

	public Integer getPopUp() {
		return popUp;
	}

	public WBannerCard setPopUp(Integer popUp) {
		this.popUp = popUp;
		return this;
	}

	public Integer getPackType() {
		return packType;
	}

	public WBannerCard setPackType(Integer packType) {
		this.packType = packType;
		return this;
	}

	public Integer getMini() {
		return mini;
	}

	public WBannerCard setMini(Integer mini) {
		this.mini = mini;
		return this;
	}

	public Integer getDisplayType() {
		return displayType;
	}

	public WBannerCard setDisplayType(Integer displayType) {
		this.displayType = displayType;
		return this;
	}

}
