/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.business.proxy.common;

import com.aliyun.opensearch.sdk.dependencies.com.google.common.collect.Sets;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.reflect.TypeToken;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.collection.OrderTool;
import com.jz.common.utils.json.GsonTools;
import com.jz.common.utils.text.StringTools;
import com.jz.jar.business.bean.AliyunBean;
import com.jz.jar.business.proxy.common.UserProxy;
import com.jz.jar.business.request.UserRequest;
import com.jz.jar.business.request.WorksRequest;
import com.jz.jar.business.wrapper.StudentWrapper;
import com.jz.jar.business.wrapper.TeacherWrapper;
import com.jz.jar.business.wrapper.UserWrapper;
import com.jz.jar.business.wrapper.WWorkTopicTheme;
import com.jz.jar.business.wrapper.WorksInfoWrapper;
import com.jz.jar.franchise.service.CourseTomatoTopicService;
import com.jz.jar.franchise.service.FUserInfoService;
import com.jz.jar.franchise.service.LessonService;
import com.jz.jar.franchise.service.SchoolService;
import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.enums.DbField;
import com.jz.jar.media.service.CommentInfoService;
import com.jz.jar.media.service.WorksAuthorService;
import com.jz.jar.media.service.WorksInfoService;
import com.jz.jar.media.service.WorksLikeService;
import com.jz.jooq.franchise.tables.pojos.CourseTomatoTopic;
import com.jz.jooq.franchise.tables.pojos.FuserInfo;
import com.jz.jooq.media.tables.pojos.WorksAuthor;
import com.jz.jooq.media.tables.pojos.WorksInfo;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class WorksInfoProxy {
    private static final Type pictureType = new TypeToken<List<String>>(){}.getType();
    @Autowired
    private CourseTomatoTopicService courseTomatoTopicService;
    @Autowired
    private WorksInfoService worksInfoService;
    @Autowired
    private WorksLikeService worksLikeService;
    @Autowired
    private UserProxy userProxy;
    @Autowired
    private CommentInfoService commentInfoService;
    @Autowired
    private WorksAuthorService worksAuthorService;
    @Autowired
    private SchoolService schoolService;
    @Autowired
    private LessonService lessonService;
    @Autowired
    private FUserInfoService teacherService;

    public List<WorksInfoWrapper> getSimpleWorksInfo(BrandEnum brand, WorksRequest request) {
        Collection suids;
        if (ArrayMapTools.isEmpty(request.getWorksId())) {
            return null;
        }
        List worksInfo = this.worksInfoService.findSimpleWorksInfo(request.getWorksId());
        if (ArrayMapTools.isEmpty((Collection)worksInfo)) {
            return null;
        }
        Map<String, UserWrapper> uid2User = null;
        Map schoolId2Name = null;
        Map<String, StudentWrapper> suid2Student = null;
        Map likeCount = null;
        List likes = null;
        HashMap wkid2Puid2Suid = Maps.newHashMap();
        HashMap workId2Suids = Maps.newHashMap();
        HashMap lessonId2Teacher = Maps.newHashMap();
        if (request.getWithExtended().booleanValue()) {
            ArrayList wkids = Lists.newArrayList();
            HashMap school2Lessons = Maps.newHashMap();
            worksInfo.forEach(it -> {
                wkids.add(it.getId());
                if (school2Lessons.containsKey(it.getSchoolId())) {
                    ((Collection)school2Lessons.get(it.getSchoolId())).add(it.getLessonId());
                } else {
                    school2Lessons.put(it.getSchoolId(), Lists.newArrayList((Object[])new String[]{it.getLessonId()}));
                }
            });
            List worksAuthors = this.worksAuthorService.findWorkAuthor(brand, (Collection)wkids);
            HashSet puids = Sets.newHashSet();
            suids = Sets.newHashSet();
            HashSet schoolIds = Sets.newHashSet();
            worksAuthors.forEach(arg_0 -> WorksInfoProxy.lambda$getSimpleWorksInfo$46(wkid2Puid2Suid, puids, (Set)suids, schoolIds, workId2Suids, arg_0));
            schoolId2Name = this.schoolService.mutiGetId2NameMap((Collection)schoolIds);
            uid2User = this.userProxy.getSimpleParentInfoHas(brand, UserRequest.of(puids));
            suid2Student = this.userProxy.getStudentSimpleInfoHasForSuid(suids, brand, request.getUid());
            likeCount = this.worksLikeService.getLikeCount(request.getWorksId());
            if (null != request.getUid()) {
                likes = this.worksLikeService.screenLike(request.getWorksId(), request.getUid());
            }
            if (ArrayMapTools.isNotEmpty((Map)school2Lessons)) {
                Map lessonId2TeacherId = this.lessonService.getLessonId2Teacher((Map)school2Lessons);
                Map<String, FuserInfo> uMap = this.teacherService.getTeachers(lessonId2TeacherId.values()).stream().collect(Collectors.toMap(m -> m.getUid(), m -> m));
                for (Map.Entry m2 : lessonId2TeacherId.entrySet()) {
                    lessonId2Teacher.put(m2.getKey(), uMap.get(m2.getValue()));
                }
            }
        }
        ArrayList wrappers = Lists.newArrayList();
        for (WorksInfo workInfo : worksInfo) {
            WorksInfoWrapper wrapper = WorksInfoWrapper.of(workInfo);
            if (null != workInfo.getPic() && workInfo.getPic().startsWith("http://")) {
                wrapper.setPic(workInfo.getPic());
            } else {
                wrapper.setPic(AliyunBean.getImagesUrl(workInfo.getPic()));
            }
            if (request.getWithExtended().booleanValue()) {
                Pair pair = (Pair)wkid2Puid2Suid.get(workInfo.getId());
                if (pair != null) {
                    wrapper.setUser(uid2User.get(pair.getKey()));
                    wrapper.setStudent(suid2Student.get(pair.getValue()));
                    wrapper.setLikeCnt(MapUtils.getInteger((Map)likeCount, (Object)workInfo.getId(), (Integer)0));
                    wrapper.setIsLike(null != likes && likes.contains(workInfo.getId()));
                }
                if (schoolId2Name.containsKey(workInfo.getSchoolId())) {
                    wrapper.setSchoolName((String)schoolId2Name.get(workInfo.getSchoolId()));
                }
                if (lessonId2Teacher.containsKey(workInfo.getLessonId())) {
                    wrapper.setTeacher(TeacherWrapper.of((FuserInfo)lessonId2Teacher.get(workInfo.getLessonId())));
                }
            }
            if (request.getWithStudent().booleanValue() && workId2Suids.containsKey(workInfo.getId())) {
                suids = (List)workId2Suids.get(workInfo.getId());
                ArrayList authors = Lists.newArrayList();
                for (String tmpSuid : suids) {
                    authors.add(suid2Student.get(tmpSuid));
                }
                wrapper.setAuthors(authors);
            }
            wrappers.add(wrapper);
        }
        return OrderTool.keepOrder(request.getWorksId(), (Collection)wrappers, WorksInfoWrapper::getId);
    }

    public Map<String, WorksInfoWrapper> getSimpleWorksInfoHas(BrandEnum brand, WorksRequest request) {
        List<WorksInfoWrapper> artInfo = this.getSimpleWorksInfo(brand, request);
        if (ArrayMapTools.isEmpty(artInfo)) {
            return Maps.newHashMap();
        }
        HashMap id2Art = Maps.newHashMap();
        artInfo.forEach(it -> id2Art.put(it.getId(), it));
        return id2Art;
    }

    public WorksInfoWrapper getWorkInfo(BrandEnum brand, WorksRequest request) {
        return this.getWorkInfoForRequest(brand, request.setWithExtended(true));
    }

    public WorksInfoWrapper getWorkInfoForRequest(BrandEnum brand, WorksRequest request) {
        boolean isOldData;
        WorksInfo workInfo = this.worksInfoService.getWorksInfo(request.getWorkId(), brand);
        if (null == workInfo) {
            return null;
        }
        if (workInfo.getIsCollective() <= 0) {
            boolean isMaster = workInfo.getPuid().equals(request.getUid());
            if (workInfo.getIsOpen() <= 0 && !isMaster) {
                return null;
            }
        }
        WorksInfoWrapper wrapper = WorksInfoWrapper.of(workInfo);
        boolean bl = isOldData = null != workInfo.getPic() && workInfo.getPic().startsWith("http://");
        if (isOldData) {
            wrapper.setPic(workInfo.getPic());
        } else {
            wrapper.setPic(AliyunBean.getImagesUrl(workInfo.getPic()));
        }
        if (StringTools.isNotEmptyAndBlank((String)workInfo.getPictures())) {
            List pics = (List)GsonTools.gson.fromJson(workInfo.getPictures(), pictureType);
            if (isOldData) {
                wrapper.setPictures(pics);
            } else {
                ArrayList pictures = Lists.newArrayList();
                pics.forEach(it -> pictures.add(AliyunBean.getImagesUrl(it)));
                wrapper.setPictures(pictures);
            }
        }
        if (request.getWithExtended().booleanValue()) {
            CourseTomatoTopic topic = this.courseTomatoTopicService.getTopic(brand.name(), workInfo.getTid());
            if (null != topic) {
                wrapper.setTheme(WWorkTopicTheme.of(topic).setPic(AliyunBean.getImagesUrl(topic.getPic())));
            }
            wrapper.setLikeCnt(this.worksLikeService.countForWorkId(workInfo.getId()));
            wrapper.setCommentCnt(this.commentInfoService.countCommentInfo(brand, DbField.works, workInfo.getId()));
            wrapper.setIsLike(this.worksLikeService.existForIdAndUid(workInfo.getId(), request.getUid()));
            String puid = this.worksAuthorService.getWorksAuthorParent(brand, workInfo.getId());
            wrapper.setUser((UserWrapper)this.userProxy.getSimpleParentInfo(brand, UserRequest.of(request.getUid(), puid)));
        }
        if (request.getWithStudent().booleanValue()) {
            List suids = this.worksAuthorService.getWorksAuthors(brand, workInfo.getId());
            wrapper.setAuthors(this.userProxy.getStudentSimpleInfo(suids, brand, request.getWithAuthorUser(), request.getUid()));
        }
        return wrapper;
    }

    private static /* synthetic */ void lambda$getSimpleWorksInfo$46(Map map, Set set, Set set2, Set set3, Map map2, WorksAuthor v) {
        map.put(v.getWorkId(), Pair.of((Object)v.getPuid(), (Object)v.getSuid()));
        set.add(v.getPuid());
        set2.add(v.getSuid());
        set3.add(v.getSchoolId());
        if (map2.containsKey(v.getWorkId())) {
            ((List)map2.get(v.getWorkId())).add(v.getSuid());
        } else {
            map2.put(v.getWorkId(), Lists.newArrayList((Object[])new String[]{v.getSuid()}));
        }
    }
}

